/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cockroachdb;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.cockroachdb.SourceInfo;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class CockroachDBSourceInfoStructMaker
extends AbstractSourceInfoStructMaker<SourceInfo> {
    private static final String FIELD_CLUSTER = "cluster";
    private static final String FIELD_RESOLVED_TS = "resolved_ts";
    private static final String FIELD_HLC = "ts_hlc";
    private Schema schema;

    public void init(String connector, String version, CommonConnectorConfig connectorConfig) {
        super.init(connector, version, connectorConfig);
        this.schema = this.commonSchemaBuilder().name("io.debezium.connector.cockroachdb.Source").field(FIELD_CLUSTER, Schema.STRING_SCHEMA).field(FIELD_RESOLVED_TS, Schema.STRING_SCHEMA).field(FIELD_HLC, Schema.OPTIONAL_STRING_SCHEMA).build();
    }

    public Schema schema() {
        return this.schema;
    }

    public Struct struct(SourceInfo sourceInfo) {
        Struct result = super.commonStruct((AbstractSourceInfo)sourceInfo);
        result.put(FIELD_CLUSTER, (Object)sourceInfo.cluster());
        result.put(FIELD_RESOLVED_TS, (Object)sourceInfo.resolvedTimestamp());
        if (sourceInfo.hlc() != null) {
            result.put(FIELD_HLC, (Object)sourceInfo.hlc());
        }
        return result;
    }
}

