/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cockroachdb;

import io.debezium.connector.cockroachdb.CockroachDBConnectorConfig;
import io.debezium.connector.cockroachdb.CockroachDBSourceInfoStructMaker;
import io.debezium.connector.cockroachdb.CockroachDBValueConverterProvider;
import io.debezium.connector.cockroachdb.connection.CockroachDBConnection;
import io.debezium.relational.CustomConverterRegistry;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.spi.topic.TopicNamingStrategy;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CockroachDBSchema
extends RelationalDatabaseSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(CockroachDBSchema.class);
    private List<TableId> discoveredTables = new ArrayList<TableId>();

    public CockroachDBSchema(CockroachDBConnectorConfig config, TopicNamingStrategy<TableId> topicNamingStrategy) {
        super((RelationalDatabaseConnectorConfig)config, topicNamingStrategy, config.getTableFilters().dataCollectionFilter(), config.getColumnFilter(), new TableSchemaBuilder((ValueConverterProvider)new CockroachDBValueConverterProvider(), config.schemaNameAdjuster(), new CustomConverterRegistry(Collections.emptyList()), new CockroachDBSourceInfoStructMaker().schema(), column -> column.name(), false), false, null);
    }

    public void initialize(CockroachDBConnectorConfig config) {
        LOGGER.info("Initializing CockroachDBSchema");
        try (CockroachDBConnection connection = new CockroachDBConnection(config);){
            connection.connect();
            this.loadTables(connection, config);
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize schema", (Throwable)e);
            throw new RuntimeException("Failed to initialize schema", e);
        }
    }

    private void loadTables(CockroachDBConnection connection, CockroachDBConnectorConfig config) throws Exception {
        LOGGER.info("Loading tables from CockroachDB");
        String sql = "SELECT table_schema, table_name FROM information_schema.tables WHERE table_schema = ? AND table_type = 'BASE TABLE'";
        try (PreparedStatement pstmt = connection.connection().prepareStatement(sql);){
            pstmt.setString(1, config.getSchemaName());
            try (ResultSet rs = pstmt.executeQuery();){
                while (rs.next()) {
                    String schemaName = rs.getString("table_schema");
                    String tableName = rs.getString("table_name");
                    TableId tableId = new TableId(config.getDatabaseName(), schemaName, tableName);
                    LOGGER.info("Found table: {}", (Object)tableId);
                    this.discoveredTables.add(tableId);
                    this.loadTableStructure(connection, tableId);
                }
            }
        }
        LOGGER.info("Schema initialization completed with {} tables", (Object)this.discoveredTables.size());
    }

    private void loadTableStructure(CockroachDBConnection connection, TableId tableId) throws Exception {
        String sql = "SELECT column_name, data_type, is_nullable, column_default FROM information_schema.columns WHERE table_schema = ? AND table_name = ? ORDER BY ordinal_position";
        try (PreparedStatement stmt = connection.connection().prepareStatement(sql);){
            stmt.setString(1, tableId.schema());
            stmt.setString(2, tableId.table());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String columnName = rs.getString("column_name");
                    String dataType = rs.getString("data_type");
                    String isNullable = rs.getString("is_nullable");
                    String columnDefault = rs.getString("column_default");
                    LOGGER.debug("Column {}: {} (nullable: {}, default: {})", new Object[]{columnName, dataType, isNullable, columnDefault});
                }
            }
        }
        LOGGER.debug("Found table structure for: {}", (Object)tableId);
    }

    public void close() {
        LOGGER.info("Closing CockroachDBSchema");
        super.close();
    }

    public List<TableId> getDiscoveredTables() {
        return this.discoveredTables;
    }
}

