/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cockroachdb;

import io.debezium.connector.cockroachdb.CockroachDBOffsetContext;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionInfo;
import io.debezium.spi.schema.DataCollectionId;
import java.time.Instant;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;

public class CockroachDBEventMetadataProvider
implements EventMetadataProvider {
    public Instant getEventTimestamp(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (offset instanceof CockroachDBOffsetContext) {
            CockroachDBOffsetContext ctx = (CockroachDBOffsetContext)offset;
            return ctx.getTimestamp();
        }
        return null;
    }

    public Map<String, String> getEventSourcePosition(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (offset instanceof CockroachDBOffsetContext) {
            CockroachDBOffsetContext ctx = (CockroachDBOffsetContext)offset;
            return Map.of("cursor", ctx.getCursor());
        }
        return Map.of();
    }

    public String getTransactionId(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        return "";
    }

    public TransactionInfo getTransactionInfo(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        return null;
    }

    public String toSummaryString(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        return String.format("CockroachDB change event on %s with key=%s", source, key);
    }
}

