/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cockroachdb;

import io.debezium.connector.cockroachdb.CockroachDBOffsetContext;
import io.debezium.connector.cockroachdb.CockroachDBPartition;
import io.debezium.connector.cockroachdb.serialization.ChangefeedSchemaParser;
import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.util.Clock;
import org.apache.kafka.connect.data.Struct;

public class CockroachDBChangeRecordEmitter
implements ChangeRecordEmitter<CockroachDBPartition> {
    private final CockroachDBPartition partition;
    private final ChangefeedSchemaParser.ParsedChange change;
    private final CockroachDBOffsetContext offsetContext;
    private final Clock clock;
    private final Envelope.Operation operation;

    public CockroachDBChangeRecordEmitter(CockroachDBPartition partition, ChangefeedSchemaParser.ParsedChange change, CockroachDBOffsetContext offsetContext, Clock clock, Envelope.Operation operation) {
        if (partition == null) {
            throw new IllegalArgumentException("Partition cannot be null");
        }
        if (change == null) {
            throw new IllegalArgumentException("Change cannot be null");
        }
        if (offsetContext == null) {
            throw new IllegalArgumentException("Offset context cannot be null");
        }
        if (clock == null) {
            throw new IllegalArgumentException("Clock cannot be null");
        }
        if (operation == null) {
            throw new IllegalArgumentException("Operation cannot be null");
        }
        this.partition = partition;
        this.change = change;
        this.offsetContext = offsetContext;
        this.clock = clock;
        this.operation = operation;
    }

    public CockroachDBPartition getPartition() {
        return this.partition;
    }

    public CockroachDBOffsetContext getOffset() {
        return this.offsetContext;
    }

    public Envelope.Operation getOperation() {
        return this.operation;
    }

    public void emitChangeRecords(DataCollectionSchema schema, ChangeRecordEmitter.Receiver<CockroachDBPartition> receiver) throws InterruptedException {
        if (schema == null) {
            throw new IllegalArgumentException("Schema cannot be null");
        }
        if (receiver == null) {
            throw new IllegalArgumentException("Receiver cannot be null");
        }
        if (this.change.key() == null) {
            throw new IllegalStateException("Change key cannot be null");
        }
        if (this.change.value() == null) {
            throw new IllegalStateException("Change value cannot be null");
        }
        receiver.changeRecord((Partition)this.partition, schema, this.operation, this.change.key(), (Struct)this.change.value(), (OffsetContext)this.offsetContext, null);
    }
}

