/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.tutorial;

import io.datafx.controller.FXMLController;
import io.datafx.controller.flow.Flow;
import io.datafx.controller.flow.FlowContainer;
import io.datafx.controller.flow.FlowException;
import io.datafx.controller.flow.FlowHandler;
import io.datafx.controller.flow.action.ActionMethod;
import io.datafx.controller.flow.action.ActionTrigger;
import io.datafx.controller.flow.container.AnimatedFlowContainer;
import io.datafx.controller.flow.container.ContainerAnimations;
import io.datafx.controller.util.VetoException;
import io.datafx.tutorial.WizardView1Controller;
import io.datafx.tutorial.WizardView2Controller;
import io.datafx.tutorial.WizardView3Controller;
import io.datafx.tutorial.WizardView4Controller;
import io.datafx.tutorial.WizardView5Controller;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import javax.annotation.PostConstruct;

@FXMLController(value="wizard.fxml")
public class WizardController {
    @FXML
    @ActionTrigger(value="back")
    private Button backButton;
    @FXML
    @ActionTrigger(value="finish")
    private Button finishButton;
    @FXML
    @ActionTrigger(value="next")
    private Button nextButton;
    @FXML
    private StackPane centerPane;
    private FlowHandler flowHandler;

    @PostConstruct
    public void init() throws FlowException {
        Flow flow = new Flow(WizardView1Controller.class).withLink(WizardView1Controller.class, "next", WizardView2Controller.class).withLink(WizardView2Controller.class, "next", WizardView3Controller.class).withLink(WizardView3Controller.class, "next", WizardView4Controller.class).withLink(WizardView4Controller.class, "next", WizardView5Controller.class);
        this.flowHandler = flow.createHandler();
        this.centerPane.getChildren().add((Object)this.flowHandler.start((FlowContainer)new AnimatedFlowContainer(Duration.millis((double)320.0), ContainerAnimations.ZOOM_IN)));
        this.backButton.setDisable(true);
    }

    @ActionMethod(value="back")
    public void onBack() throws VetoException, FlowException {
        this.flowHandler.navigateBack();
        if (this.flowHandler.getCurrentViewControllerClass().equals(WizardView1Controller.class)) {
            this.backButton.setDisable(true);
        } else {
            this.backButton.setDisable(false);
        }
        this.finishButton.setDisable(false);
        this.nextButton.setDisable(false);
    }

    @ActionMethod(value="next")
    public void onNext() throws VetoException, FlowException {
        this.flowHandler.handle("next");
        if (this.flowHandler.getCurrentViewControllerClass().equals(WizardView5Controller.class)) {
            this.nextButton.setDisable(true);
            this.finishButton.setDisable(true);
        } else {
            this.nextButton.setDisable(false);
        }
        this.backButton.setDisable(false);
    }

    @ActionMethod(value="finish")
    public void onFinish() throws VetoException, FlowException {
        this.flowHandler.navigateTo(WizardView5Controller.class);
        this.finishButton.setDisable(true);
        this.nextButton.setDisable(true);
        this.backButton.setDisable(false);
    }
}

