/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.query;

import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.TableRow;
import io.cucumber.query.Lineage;
import io.cucumber.query.LineageCollector;
import io.cucumber.query.LineageReducer;
import java.util.Objects;
import java.util.function.Supplier;

class LineageReducerDescending<T>
implements LineageReducer<T> {
    private final Supplier<? extends LineageCollector<T>> reducerSupplier;

    LineageReducerDescending(Supplier<? extends LineageCollector<T>> reducerSupplier) {
        this.reducerSupplier = Objects.requireNonNull(reducerSupplier);
    }

    @Override
    public T reduce(Lineage lineage) {
        LineageCollector<T> reducer = this.reducerSupplier.get();
        LineageReducerDescending.reduceAddLineage(reducer, lineage);
        return reducer.finish();
    }

    @Override
    public T reduce(Lineage lineage, Pickle pickle) {
        LineageCollector<T> reducer = this.reducerSupplier.get();
        LineageReducerDescending.reduceAddLineage(reducer, lineage);
        reducer.add(pickle);
        return reducer.finish();
    }

    private static <T> void reduceAddLineage(LineageCollector<T> reducer, Lineage lineage) {
        reducer.add(lineage.document());
        lineage.feature().ifPresent(reducer::add);
        lineage.rule().ifPresent(reducer::add);
        lineage.scenario().ifPresent(reducer::add);
        lineage.examples().ifPresent(examples -> reducer.add((Examples)examples, (int)lineage.examplesIndex().orElse(0)));
        lineage.example().ifPresent(example -> reducer.add((TableRow)example, (int)lineage.exampleIndex().orElse(0)));
    }
}

