/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.query;

import io.cucumber.messages.Convertor;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.TestCase;
import io.cucumber.messages.types.TestCaseFinished;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestRunFinished;
import io.cucumber.messages.types.TestRunStarted;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.messages.types.Timestamp;
import io.cucumber.query.Lineage;
import io.cucumber.query.LineageReducer;
import io.cucumber.query.Lineages;
import io.cucumber.query.NamingStrategy;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class Query {
    private static final Map<TestStepResultStatus, Long> ZEROES_BY_TEST_STEP_RESULT_STATUSES = Arrays.stream(TestStepResultStatus.values()).collect(Collectors.toMap(Function.identity(), s -> 0L));
    private final Comparator<TestStepResult> testStepResultComparator = Comparator.nullsFirst(Comparator.comparing(o -> o.getStatus().ordinal()));
    private final Deque<TestCaseStarted> testCaseStarted = new ConcurrentLinkedDeque<TestCaseStarted>();
    private final Map<String, TestCaseFinished> testCaseFinishedByTestCaseStartedId = new ConcurrentHashMap<String, TestCaseFinished>();
    private final Map<String, List<TestStepFinished>> testStepsFinishedByTestCaseStartedId = new ConcurrentHashMap<String, List<TestStepFinished>>();
    private final Map<String, Pickle> pickleById = new ConcurrentHashMap<String, Pickle>();
    private final Map<String, TestCase> testCaseById = new ConcurrentHashMap<String, TestCase>();
    private final Map<String, Step> stepById = new ConcurrentHashMap<String, Step>();
    private final Map<String, TestStep> testStepById = new ConcurrentHashMap<String, TestStep>();
    private final Map<String, PickleStep> pickleStepById = new ConcurrentHashMap<String, PickleStep>();
    private final Map<Object, Lineage> lineageById = new ConcurrentHashMap<Object, Lineage>();
    private TestRunStarted testRunStarted;
    private TestRunFinished testRunFinished;

    public Map<TestStepResultStatus, Long> countMostSevereTestStepResultStatus() {
        EnumMap<TestStepResultStatus, Long> results = new EnumMap<TestStepResultStatus, Long>(ZEROES_BY_TEST_STEP_RESULT_STATUSES);
        results.putAll(this.findAllTestCaseStarted().stream().map(this::findMostSevereTestStepResultBy).filter(Optional::isPresent).map(Optional::get).map(TestStepResult::getStatus).collect(Collectors.groupingBy(Function.identity(), LinkedHashMap::new, Collectors.counting())));
        return results;
    }

    public int countTestCasesStarted() {
        return this.findAllTestCaseStarted().size();
    }

    public List<Pickle> findAllPickles() {
        return this.pickleById.values().stream().sorted(Comparator.comparing(Pickle::getId)).collect(Collectors.toList());
    }

    public List<PickleStep> findAllPickleSteps() {
        return this.pickleStepById.values().stream().sorted(Comparator.comparing(PickleStep::getId)).collect(Collectors.toList());
    }

    public List<TestCaseStarted> findAllTestCaseStarted() {
        return this.testCaseStarted.stream().filter(testCaseStarted1 -> !this.findTestCaseFinishedBy((TestCaseStarted)testCaseStarted1).filter(TestCaseFinished::getWillBeRetried).isPresent()).collect(Collectors.toList());
    }

    public Map<Optional<Feature>, List<TestCaseStarted>> findAllTestCaseStartedGroupedByFeature() {
        return this.findAllTestCaseStarted().stream().map(testCaseStarted1 -> {
            Optional<Lineage> astNodes = this.findLineageBy((TestCaseStarted)testCaseStarted1);
            return new AbstractMap.SimpleEntry<Optional<Lineage>, TestCaseStarted>(astNodes, (TestCaseStarted)testCaseStarted1);
        }).sorted(Comparator.nullsFirst(Comparator.comparing(entry1 -> ((Optional)entry1.getKey()).flatMap(nodes -> nodes.document().getUri()).orElse(null)))).map(entry -> {
            Optional feature = ((Optional)entry.getKey()).flatMap(Lineage::feature);
            TestCaseStarted testcaseStarted = (TestCaseStarted)entry.getValue();
            return new AbstractMap.SimpleEntry(feature, testcaseStarted);
        }).collect(Collectors.groupingBy(AbstractMap.SimpleEntry::getKey, LinkedHashMap::new, Collectors.collectingAndThen(Collectors.toList(), entries -> entries.stream().map(AbstractMap.SimpleEntry::getValue).collect(Collectors.toList()))));
    }

    public List<TestStep> findAllTestSteps() {
        return this.testStepById.values().stream().sorted(Comparator.comparing(TestStep::getId)).collect(Collectors.toList());
    }

    public Optional<Feature> findFeatureBy(TestCaseStarted testCaseStarted) {
        return this.findLineageBy(testCaseStarted).flatMap(Lineage::feature);
    }

    public Optional<TestStepResult> findMostSevereTestStepResultBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        return this.findTestStepsFinishedBy(testCaseStarted).stream().map(TestStepFinished::getTestStepResult).max(this.testStepResultComparator);
    }

    public String findNameOf(GherkinDocument element, NamingStrategy namingStrategy) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(namingStrategy);
        return this.reduceLinageOf(element, namingStrategy).orElseThrow(Query.createElementWasNotPartOfThisQueryObject());
    }

    public String findNameOf(Feature element, NamingStrategy namingStrategy) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(namingStrategy);
        return this.reduceLinageOf(element, namingStrategy).orElseThrow(Query.createElementWasNotPartOfThisQueryObject());
    }

    public String findNameOf(Rule element, NamingStrategy namingStrategy) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(namingStrategy);
        return this.reduceLinageOf(element, namingStrategy).orElseThrow(Query.createElementWasNotPartOfThisQueryObject());
    }

    public String findNameOf(Scenario element, NamingStrategy namingStrategy) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(namingStrategy);
        return this.reduceLinageOf(element, namingStrategy).orElseThrow(Query.createElementWasNotPartOfThisQueryObject());
    }

    public String findNameOf(Examples element, NamingStrategy namingStrategy) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(namingStrategy);
        return this.reduceLinageOf(element, namingStrategy).orElseThrow(Query.createElementWasNotPartOfThisQueryObject());
    }

    public String findNameOf(TableRow element, NamingStrategy namingStrategy) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(namingStrategy);
        return this.reduceLinageOf(element, namingStrategy).orElseThrow(Query.createElementWasNotPartOfThisQueryObject());
    }

    public String findNameOf(Pickle element, NamingStrategy namingStrategy) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(namingStrategy);
        return this.reduceLinageOf(element, namingStrategy).orElseGet(() -> ((Pickle)element).getName());
    }

    private static Supplier<IllegalArgumentException> createElementWasNotPartOfThisQueryObject() {
        return () -> new IllegalArgumentException("Element was not part of this query object");
    }

    <T> Optional<T> reduceLinageOf(GherkinDocument element, LineageReducer<T> reducer) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(reducer);
        return this.findLineageBy(element).map(reducer::reduce);
    }

    <T> Optional<T> reduceLinageOf(Feature element, LineageReducer<T> reducer) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(reducer);
        return this.findLineageBy(element).map(reducer::reduce);
    }

    <T> Optional<T> reduceLinageOf(Rule element, LineageReducer<T> reducer) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(reducer);
        return this.findLineageBy(element).map(reducer::reduce);
    }

    <T> Optional<T> reduceLinageOf(Scenario element, LineageReducer<T> reducer) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(reducer);
        return this.findLineageBy(element).map(reducer::reduce);
    }

    <T> Optional<T> reduceLinageOf(Examples element, LineageReducer<T> reducer) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(reducer);
        return this.findLineageBy(element).map(reducer::reduce);
    }

    <T> Optional<T> reduceLinageOf(TableRow element, LineageReducer<T> reducer) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(reducer);
        return this.findLineageBy(element).map(reducer::reduce);
    }

    <T> Optional<T> reduceLinageOf(Pickle element, LineageReducer<T> reducer) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(reducer);
        return this.findLineageBy(element).map(lineage -> reducer.reduce((Lineage)lineage, element));
    }

    public Optional<Pickle> findPickleBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        return this.findTestCaseBy(testCaseStarted).map(TestCase::getPickleId).map(this.pickleById::get);
    }

    public Optional<PickleStep> findPickleStepBy(TestStep testStep) {
        Objects.requireNonNull(testStep);
        return testStep.getPickleStepId().map(this.pickleStepById::get);
    }

    public Optional<Step> findStepBy(PickleStep pickleStep) {
        Objects.requireNonNull(pickleStep);
        String stepId = (String)pickleStep.getAstNodeIds().get(0);
        return Optional.ofNullable(this.stepById.get(stepId));
    }

    public Optional<TestCase> findTestCaseBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        return Optional.ofNullable(this.testCaseById.get(testCaseStarted.getTestCaseId()));
    }

    public Optional<Duration> findTestCaseDurationBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        Timestamp started = testCaseStarted.getTimestamp();
        return this.findTestCaseFinishedBy(testCaseStarted).map(TestCaseFinished::getTimestamp).map(finished -> Duration.between(Convertor.toInstant((Timestamp)started), Convertor.toInstant((Timestamp)finished)));
    }

    public Optional<TestCaseFinished> findTestCaseFinishedBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        return Optional.ofNullable(this.testCaseFinishedByTestCaseStartedId.get(testCaseStarted.getId()));
    }

    public Optional<Duration> findTestRunDuration() {
        if (this.testRunStarted == null || this.testRunFinished == null) {
            return Optional.empty();
        }
        Duration between = Duration.between(Convertor.toInstant((Timestamp)this.testRunStarted.getTimestamp()), Convertor.toInstant((Timestamp)this.testRunFinished.getTimestamp()));
        return Optional.of(between);
    }

    public Optional<TestRunFinished> findTestRunFinished() {
        return Optional.ofNullable(this.testRunFinished);
    }

    public Optional<TestRunStarted> findTestRunStarted() {
        return Optional.ofNullable(this.testRunStarted);
    }

    public Optional<TestStep> findTestStepBy(TestStepFinished testStepFinished) {
        Objects.requireNonNull(testStepFinished);
        return Optional.ofNullable(this.testStepById.get(testStepFinished.getTestStepId()));
    }

    public List<TestStepFinished> findTestStepsFinishedBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        List testStepsFinished = this.testStepsFinishedByTestCaseStartedId.getOrDefault(testCaseStarted.getId(), Collections.emptyList());
        return new ArrayList<TestStepFinished>(testStepsFinished);
    }

    public List<Map.Entry<TestStepFinished, TestStep>> findTestStepFinishedAndTestStepBy(TestCaseStarted testCaseStarted) {
        return this.findTestStepsFinishedBy(testCaseStarted).stream().map(testStepFinished -> this.findTestStepBy((TestStepFinished)testStepFinished).map(testStep -> new AbstractMap.SimpleEntry<TestStepFinished, TestStep>((TestStepFinished)testStepFinished, (TestStep)testStep))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public void update(Envelope envelope) {
        envelope.getTestRunStarted().ifPresent(this::updateTestRunStarted);
        envelope.getTestRunFinished().ifPresent(this::updateTestRunFinished);
        envelope.getTestCaseStarted().ifPresent(this::updateTestCaseStarted);
        envelope.getTestCaseFinished().ifPresent(this::updateTestCaseFinished);
        envelope.getTestStepFinished().ifPresent(this::updateTestStepFinished);
        envelope.getGherkinDocument().ifPresent(this::updateGherkinDocument);
        envelope.getPickle().ifPresent(this::updatePickle);
        envelope.getTestCase().ifPresent(this::updateTestCase);
    }

    private Optional<Lineage> findLineageBy(GherkinDocument element) {
        Objects.requireNonNull(element);
        return Optional.ofNullable(this.lineageById.get(element.getUri()));
    }

    private Optional<Lineage> findLineageBy(Feature element) {
        Objects.requireNonNull(element);
        return Optional.ofNullable(this.lineageById.get(element));
    }

    private Optional<Lineage> findLineageBy(Rule element) {
        Objects.requireNonNull(element);
        return Optional.ofNullable(this.lineageById.get(element.getId()));
    }

    private Optional<Lineage> findLineageBy(Scenario element) {
        Objects.requireNonNull(element);
        return Optional.ofNullable(this.lineageById.get(element.getId()));
    }

    private Optional<Lineage> findLineageBy(Examples element) {
        Objects.requireNonNull(element);
        return Optional.ofNullable(this.lineageById.get(element.getId()));
    }

    private Optional<Lineage> findLineageBy(TableRow element) {
        Objects.requireNonNull(element);
        return Optional.ofNullable(this.lineageById.get(element.getId()));
    }

    private Optional<Lineage> findLineageBy(Pickle pickle) {
        Objects.requireNonNull(pickle);
        List astNodeIds = pickle.getAstNodeIds();
        String pickleAstNodeId = (String)astNodeIds.get(astNodeIds.size() - 1);
        return Optional.ofNullable(this.lineageById.get(pickleAstNodeId));
    }

    private Optional<Lineage> findLineageBy(TestCaseStarted testCaseStarted) {
        return this.findPickleBy(testCaseStarted).flatMap(this::findLineageBy);
    }

    private void updateTestCaseStarted(TestCaseStarted testCaseStarted) {
        this.testCaseStarted.add(testCaseStarted);
    }

    private void updateTestCase(TestCase event) {
        this.testCaseById.put(event.getId(), event);
        event.getTestSteps().forEach(testStep -> this.testStepById.put(testStep.getId(), (TestStep)testStep));
    }

    private void updatePickle(Pickle event) {
        this.pickleById.put(event.getId(), event);
        event.getSteps().forEach(pickleStep -> this.pickleStepById.put(pickleStep.getId(), (PickleStep)pickleStep));
    }

    private void updateGherkinDocument(GherkinDocument document) {
        this.lineageById.putAll(Lineages.of(document));
        document.getFeature().ifPresent(this::updateFeature);
    }

    private void updateFeature(Feature feature) {
        feature.getChildren().forEach(featureChild -> {
            featureChild.getBackground().ifPresent(background -> this.updateSteps(background.getSteps()));
            featureChild.getScenario().ifPresent(this::updateScenario);
            featureChild.getRule().ifPresent(rule -> rule.getChildren().forEach(ruleChild -> {
                ruleChild.getBackground().ifPresent(background -> this.updateSteps(background.getSteps()));
                ruleChild.getScenario().ifPresent(this::updateScenario);
            }));
        });
    }

    private void updateTestStepFinished(TestStepFinished event) {
        this.testStepsFinishedByTestCaseStartedId.compute(event.getTestCaseStartedId(), this.updateList(event));
    }

    private void updateTestCaseFinished(TestCaseFinished event) {
        this.testCaseFinishedByTestCaseStartedId.put(event.getTestCaseStartedId(), event);
    }

    private void updateTestRunFinished(TestRunFinished event) {
        this.testRunFinished = event;
    }

    private void updateTestRunStarted(TestRunStarted event) {
        this.testRunStarted = event;
    }

    private void updateScenario(Scenario scenario) {
        this.updateSteps(scenario.getSteps());
    }

    private void updateSteps(List<Step> steps) {
        steps.forEach(step -> this.stepById.put(step.getId(), (Step)step));
    }

    private <K, E> BiFunction<K, List<E>, List<E>> updateList(E element) {
        return (key, existing) -> {
            if (existing != null) {
                existing.add(element);
                return existing;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(element);
            return list;
        };
    }
}

