/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.environment;

import io.cucumber.pro.config.Config;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class EnvFilter {
    private final Pattern maskPattern;

    public EnvFilter(Config config) {
        String mask = config.getString("cucumberpro.envmask");
        this.maskPattern = Pattern.compile(String.format(".*(%s).*", mask), 2);
    }

    public Map<String, String> filter(Map<String, String> env) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            if (this.maskPattern.matcher(entry.getKey()).matches()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

