/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.environment;

import java.util.Map;

public class CIEnvironment {
    private final String ciName;
    private final String revision;
    private final String branch;
    private final String tag;
    private final String projectName;

    CIEnvironment(String ciName, String revision, String branch, String tag, String projectName) {
        this.ciName = ciName;
        this.revision = revision;
        this.branch = branch;
        this.tag = tag;
        this.projectName = projectName;
    }

    public static CIEnvironment detect(Map<String, String> env) {
        CIEnvironment ci = CIEnvironment.detectBamboo(env);
        if (ci != null) {
            return ci;
        }
        ci = CIEnvironment.detectCircle(env);
        if (ci != null) {
            return ci;
        }
        ci = CIEnvironment.detectJenkins(env);
        if (ci != null) {
            return ci;
        }
        ci = CIEnvironment.detectTfs(env);
        if (ci != null) {
            return ci;
        }
        ci = CIEnvironment.detectTravis(env);
        if (ci != null) {
            return ci;
        }
        ci = CIEnvironment.detectWercker(env);
        if (ci != null) {
            return ci;
        }
        return null;
    }

    private static CIEnvironment detectBamboo(Map<String, String> env) {
        String revision = env.get("bamboo_planRepository_revision");
        String branch = env.get("bamboo_repository_git_branch");
        if (revision == null || branch == null) {
            return null;
        }
        String tag = null;
        String projectName = env.get("bamboo_planRepository_name");
        return new CIEnvironment("Bamboo", revision, branch, tag, projectName);
    }

    private static CIEnvironment detectCircle(Map<String, String> env) {
        String revision = env.get("CIRCLE_SHA1");
        String branch = env.get("CIRCLE_BRANCH");
        if (revision == null || branch == null) {
            return null;
        }
        String tag = env.get("CIRCLE_TAG");
        String projectName = env.get("CIRCLE_PROJECT_REPONAME");
        return new CIEnvironment("Circle CI", revision, branch, tag, projectName);
    }

    private static CIEnvironment detectJenkins(Map<String, String> env) {
        String revision = env.get("GIT_COMMIT");
        String branch = env.get("GIT_BRANCH");
        if (revision == null || branch == null) {
            return null;
        }
        String tag = env.get("GIT_TAG_NAME");
        String projectName = null;
        return new CIEnvironment("Jenkins", revision, branch, tag, projectName);
    }

    private static CIEnvironment detectTfs(Map<String, String> env) {
        String revision = env.get("BUILD_SOURCEVERSION");
        String branch = env.get("BUILD_SOURCEBRANCHNAME");
        if (revision == null || branch == null) {
            return null;
        }
        String tag = null;
        String projectName = env.get("SYSTEM_TEAMPROJECT");
        return new CIEnvironment("TFS", revision, branch, tag, projectName);
    }

    private static CIEnvironment detectTravis(Map<String, String> env) {
        String revision = env.get("TRAVIS_COMMIT");
        String branch = env.get("TRAVIS_BRANCH");
        if (revision == null || branch == null) {
            return null;
        }
        String tag = null;
        String repoSlug = env.get("TRAVIS_REPO_SLUG");
        String projectName = repoSlug.split("/")[1];
        return new CIEnvironment("Travis CI", revision, branch, tag, projectName);
    }

    private static CIEnvironment detectWercker(Map<String, String> env) {
        String revision = env.get("WERCKER_GIT_COMMIT");
        String branch = env.get("WERCKER_GIT_BRANCH");
        if (revision == null || branch == null) {
            return null;
        }
        String tag = null;
        String projectName = env.get("WERCKER_GIT_REPOSITORY");
        return new CIEnvironment("Wercker", revision, branch, tag, projectName);
    }

    public String getCiName() {
        return this.ciName;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getTag() {
        return this.tag;
    }

    public String getProjectName() {
        return this.projectName;
    }
}

