/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.environment;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BambooEnvironmentVariables {
    private static Pattern BAMBOO_PATTERN = Pattern.compile("^bamboo_(.+)");

    public Map<String, String> convert(Map<String, String> env) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : env.keySet()) {
            Matcher matcher = BAMBOO_PATTERN.matcher(key);
            if (!matcher.lookingAt()) continue;
            String value = env.get(key);
            String strippedVar = matcher.group(1);
            result.put(strippedVar, value);
        }
        result.putAll(env);
        return result;
    }
}

