/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.treewalk.filter;

import io.cucumber.pro.shaded.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import io.cucumber.pro.shaded.org.eclipse.jgit.errors.MissingObjectException;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.JGitText;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Constants;
import io.cucumber.pro.shaded.org.eclipse.jgit.treewalk.TreeWalk;
import io.cucumber.pro.shaded.org.eclipse.jgit.treewalk.filter.TreeFilter;
import java.io.IOException;

public class PathSuffixFilter
extends TreeFilter {
    final String pathStr;
    final byte[] pathRaw;

    public static PathSuffixFilter create(String path) {
        if (path.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().emptyPathNotPermitted);
        }
        return new PathSuffixFilter(path);
    }

    private PathSuffixFilter(String s) {
        this.pathStr = s;
        this.pathRaw = Constants.encode(this.pathStr);
    }

    @Override
    public TreeFilter clone() {
        return this;
    }

    @Override
    public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (walker.isSubtree()) {
            return true;
        }
        return walker.isPathSuffix(this.pathRaw, this.pathRaw.length);
    }

    @Override
    public boolean shouldBeRecursive() {
        return true;
    }
}

