/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.storage.pack;

import io.cucumber.pro.shaded.org.eclipse.jgit.internal.JGitText;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.pack.CachedPack;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectId;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PackStatistics {
    private Accumulator statistics;

    public PackStatistics(Accumulator accumulator) {
        this.statistics = accumulator;
    }

    public Set<ObjectId> getInterestingObjects() {
        return this.statistics.interestingObjects;
    }

    public Set<ObjectId> getUninterestingObjects() {
        return this.statistics.uninterestingObjects;
    }

    public Set<ObjectId> getClientShallowCommits() {
        return this.statistics.clientShallowCommits;
    }

    public List<CachedPack> getReusedPacks() {
        return this.statistics.reusedPacks;
    }

    public Set<ObjectId> getRootCommits() {
        return this.statistics.rootCommits;
    }

    public int getDeltaSearchNonEdgeObjects() {
        return this.statistics.deltaSearchNonEdgeObjects;
    }

    public int getDeltasFound() {
        return this.statistics.deltasFound;
    }

    public long getTotalObjects() {
        return this.statistics.totalObjects;
    }

    public long getBitmapIndexMisses() {
        return this.statistics.bitmapIndexMisses;
    }

    public long getTotalDeltas() {
        return this.statistics.totalDeltas;
    }

    public long getReusedObjects() {
        return this.statistics.reusedObjects;
    }

    public long getReusedDeltas() {
        return this.statistics.reusedDeltas;
    }

    public long getTotalBytes() {
        return this.statistics.totalBytes;
    }

    public long getThinPackBytes() {
        return this.statistics.thinPackBytes;
    }

    public ObjectType byObjectType(int typeCode) {
        return new ObjectType(this.statistics.objectTypes[typeCode]);
    }

    public boolean isShallow() {
        return this.statistics.depth > 0;
    }

    public int getDepth() {
        return this.statistics.depth;
    }

    public long getTimeCounting() {
        return this.statistics.timeCounting;
    }

    public long getTimeSearchingForReuse() {
        return this.statistics.timeSearchingForReuse;
    }

    public long getTimeSearchingForSizes() {
        return this.statistics.timeSearchingForSizes;
    }

    public long getTimeCompressing() {
        return this.statistics.timeCompressing;
    }

    public long getTimeWriting() {
        return this.statistics.timeWriting;
    }

    public long getTimeTotal() {
        return this.statistics.timeCounting + this.statistics.timeSearchingForReuse + this.statistics.timeSearchingForSizes + this.statistics.timeCompressing + this.statistics.timeWriting;
    }

    public double getTransferRate() {
        return (double)this.getTotalBytes() / ((double)this.getTimeWriting() / 1000.0);
    }

    public String getMessage() {
        return MessageFormat.format(JGitText.get().packWriterStatistics, this.statistics.totalObjects, this.statistics.totalDeltas, this.statistics.reusedObjects, this.statistics.reusedDeltas);
    }

    public Map<Integer, ObjectType> getObjectTypes() {
        HashMap<Integer, ObjectType> map = new HashMap<Integer, ObjectType>();
        map.put(3, new ObjectType(this.statistics.objectTypes[3]));
        map.put(1, new ObjectType(this.statistics.objectTypes[1]));
        map.put(4, new ObjectType(this.statistics.objectTypes[4]));
        map.put(2, new ObjectType(this.statistics.objectTypes[2]));
        return map;
    }

    public static class Accumulator {
        public Set<ObjectId> interestingObjects;
        public Set<ObjectId> uninterestingObjects;
        public Set<ObjectId> clientShallowCommits;
        public List<CachedPack> reusedPacks;
        public Set<ObjectId> rootCommits;
        public int depth;
        public int deltaSearchNonEdgeObjects;
        public int deltasFound;
        public long totalObjects;
        public long bitmapIndexMisses;
        public long totalDeltas;
        public long reusedObjects;
        public long reusedDeltas;
        public long totalBytes;
        public long thinPackBytes;
        public long timeCounting;
        public long timeSearchingForReuse;
        public long timeSearchingForSizes;
        public long timeCompressing;
        public long timeWriting;
        public ObjectType.Accumulator[] objectTypes = new ObjectType.Accumulator[5];

        public Accumulator() {
            this.objectTypes[1] = new ObjectType.Accumulator();
            this.objectTypes[2] = new ObjectType.Accumulator();
            this.objectTypes[3] = new ObjectType.Accumulator();
            this.objectTypes[4] = new ObjectType.Accumulator();
        }
    }

    public static class ObjectType {
        private Accumulator objectType;

        public ObjectType(Accumulator accumulator) {
            this.objectType = accumulator;
        }

        public long getObjects() {
            return this.objectType.cntObjects;
        }

        public long getDeltas() {
            return this.objectType.cntDeltas;
        }

        public long getReusedObjects() {
            return this.objectType.reusedObjects;
        }

        public long getReusedDeltas() {
            return this.objectType.reusedDeltas;
        }

        public long getBytes() {
            return this.objectType.bytes;
        }

        public long getDeltaBytes() {
            return this.objectType.deltaBytes;
        }

        public static class Accumulator {
            public long cntObjects;
            public long cntDeltas;
            public long reusedObjects;
            public long reusedDeltas;
            public long bytes;
            public long deltaBytes;
        }
    }
}

