/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.reftree;

import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.reftree.Command;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.reftree.RefTreeBatch;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.reftree.RefTreeDatabase;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.reftree.RefTreeUpdate;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectId;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectIdRef;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Ref;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.RefRename;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.RefUpdate;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.SymbolicRef;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevWalk;
import java.io.IOException;
import java.util.ArrayList;

class RefTreeRename
extends RefRename {
    private final RefTreeDatabase refdb;

    RefTreeRename(RefTreeDatabase refdb, RefUpdate src, RefUpdate dst) {
        super(src, dst);
        this.refdb = refdb;
    }

    @Override
    protected RefUpdate.Result doRename() throws IOException {
        try (RevWalk rw = new RevWalk(this.refdb.getRepository());){
            RefTreeBatch batch = new RefTreeBatch(this.refdb);
            batch.setRefLogIdent(this.getRefLogIdent());
            batch.setRefLogMessage(this.getRefLogMessage(), false);
            batch.init(rw);
            Ref head = batch.exactRef(rw.getObjectReader(), "HEAD");
            Ref oldRef = batch.exactRef(rw.getObjectReader(), this.source.getName());
            if (oldRef == null) {
                RefUpdate.Result result = RefUpdate.Result.REJECTED;
                return result;
            }
            Ref newRef = this.asNew(oldRef);
            ArrayList<Command> mv = new ArrayList<Command>(3);
            mv.add(new Command(oldRef, null));
            mv.add(new Command(null, newRef));
            if (head != null && head.isSymbolic() && head.getTarget().getName().equals(oldRef.getName())) {
                mv.add(new Command(head, new SymbolicRef(head.getName(), newRef)));
            }
            batch.execute(rw, mv);
            RefUpdate.Result result = RefTreeUpdate.translate(((Command)mv.get(1)).getResult(), RefUpdate.Result.RENAMED);
            return result;
        }
    }

    private Ref asNew(Ref src) {
        String name = this.destination.getName();
        if (src.isSymbolic()) {
            return new SymbolicRef(name, src.getTarget());
        }
        ObjectId peeled = src.getPeeledObjectId();
        if (peeled != null) {
            return new ObjectIdRef.PeeledTag(src.getStorage(), name, src.getObjectId(), peeled);
        }
        return new ObjectIdRef.PeeledNonTag(src.getStorage(), name, src.getObjectId());
    }
}

