/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.internal.ketch;

import io.cucumber.pro.shaded.org.eclipse.jgit.annotations.Nullable;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.CommitBuilder;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectId;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectInserter;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.PersonIdent;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevCommit;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevObject;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevWalk;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.ReceiveCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class StageBuilder {
    private static final int SMALL_BATCH_SIZE = 5;
    private static final int TEMP_PARENT_BATCH_SIZE = 128;
    private static final byte[] PEEL = new byte[]{32, 94};
    private final String txnStage;
    private final String txnId;

    public StageBuilder(String txnStageNamespace, ObjectId txnId) {
        this.txnStage = txnStageNamespace;
        this.txnId = txnId.name();
    }

    /*
     * Exception decompiling
     */
    public List<ReceiveCommand> makeStageList(Repository git, ObjectId oldTree, ObjectId newTree) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<ReceiveCommand> makeStageList(Set<ObjectId> newObjs, @Nullable Repository git, @Nullable ObjectInserter inserter) throws IOException {
        if (git == null || newObjs.size() <= 5) {
            ArrayList<ReceiveCommand> cmds = new ArrayList<ReceiveCommand>(newObjs.size());
            for (ObjectId id : newObjs) {
                this.stage(cmds, id);
            }
            return cmds;
        }
        ArrayList<ReceiveCommand> cmds = new ArrayList<ReceiveCommand>();
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        this.reduceObjects(cmds, commits, git, newObjs);
        if (inserter == null || commits.size() <= 1 || cmds.size() + commits.size() <= 5) {
            for (RevCommit c : commits) {
                this.stage(cmds, c.copy());
            }
            return cmds;
        }
        ObjectId tip = null;
        int end = commits.size();
        while (end > 0) {
            int start = Math.max(0, end - 128);
            List<RevCommit> batch = commits.subList(start, end);
            ArrayList<ObjectId> parents = new ArrayList<ObjectId>(1 + batch.size());
            if (tip != null) {
                parents.add(tip);
            }
            parents.addAll(batch);
            CommitBuilder b = new CommitBuilder();
            b.setTreeId(((RevCommit)batch.get(0)).getTree());
            b.setParentIds(parents);
            b.setAuthor(StageBuilder.tmpAuthor(batch));
            b.setCommitter(b.getAuthor());
            tip = inserter.insert(b);
            end = start;
        }
        this.stage(cmds, tip);
        return cmds;
    }

    private static PersonIdent tmpAuthor(List<RevCommit> commits) {
        int t = 0;
        int i = 0;
        while (i < commits.size()) {
            t = Math.max(t, commits.get(i).getCommitTime());
        }
        String name = "Ketch Stage";
        String email = "tmp@tmp";
        return new PersonIdent(name, email, (long)t * 1000L, 0);
    }

    private void reduceObjects(List<ReceiveCommand> cmds, List<RevCommit> commits, Repository git, Set<ObjectId> newObjs) throws IOException {
        try (RevWalk rw = new RevWalk(git);){
            RevCommit c;
            rw.setRetainBody(false);
            for (ObjectId id : newObjs) {
                RevObject obj = rw.parseAny(id);
                if (obj instanceof RevCommit) {
                    rw.markStart((RevCommit)obj);
                    continue;
                }
                this.stage(cmds, id);
            }
            while ((c = rw.next()) != null) {
                commits.add(c);
                rw.markUninteresting(c);
            }
        }
    }

    private void stage(List<ReceiveCommand> cmds, ObjectId id) {
        int estLen = this.txnStage.length() + this.txnId.length() + 5;
        StringBuilder n = new StringBuilder(estLen);
        n.append(this.txnStage).append(this.txnId).append('.');
        n.append(Integer.toHexString(cmds.size()));
        cmds.add(new ReceiveCommand(ObjectId.zeroId(), id, n.toString()));
    }
}

