/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.api;

import io.cucumber.pro.shaded.org.eclipse.jgit.api.GitCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.GitAPIException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.JGitInternalException;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Ref;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.notes.Note;
import io.cucumber.pro.shaded.org.eclipse.jgit.notes.NoteMap;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevCommit;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevObject;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevWalk;
import java.io.IOException;

public class ShowNoteCommand
extends GitCommand<Note> {
    private RevObject id;
    private String notesRef = "refs/notes/commits";

    protected ShowNoteCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Note call() throws GitAPIException {
        this.checkCallable();
        NoteMap map = NoteMap.newEmptyMap();
        RevCommit notesCommit = null;
        try (RevWalk walk = new RevWalk(this.repo);){
            Ref ref = this.repo.exactRef(this.notesRef);
            if (ref != null) {
                notesCommit = walk.parseCommit(ref.getObjectId());
                map = NoteMap.read(walk.getObjectReader(), notesCommit);
            }
            Note note = map.getNote(this.id);
            return note;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public ShowNoteCommand setObjectId(RevObject id) {
        this.checkCallable();
        this.id = id;
        return this;
    }

    public ShowNoteCommand setNotesRef(String notesRef) {
        this.checkCallable();
        this.notesRef = notesRef;
        return this;
    }
}

