/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.api;

import io.cucumber.pro.shaded.org.eclipse.jgit.api.MergeResult;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.RebaseResult;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.FetchResult;

public class PullResult {
    private final FetchResult fetchResult;
    private final MergeResult mergeResult;
    private final RebaseResult rebaseResult;
    private final String fetchedFrom;

    PullResult(FetchResult fetchResult, String fetchedFrom, MergeResult mergeResult) {
        this.fetchResult = fetchResult;
        this.fetchedFrom = fetchedFrom;
        this.mergeResult = mergeResult;
        this.rebaseResult = null;
    }

    PullResult(FetchResult fetchResult, String fetchedFrom, RebaseResult rebaseResult) {
        this.fetchResult = fetchResult;
        this.fetchedFrom = fetchedFrom;
        this.mergeResult = null;
        this.rebaseResult = rebaseResult;
    }

    public FetchResult getFetchResult() {
        return this.fetchResult;
    }

    public MergeResult getMergeResult() {
        return this.mergeResult;
    }

    public RebaseResult getRebaseResult() {
        return this.rebaseResult;
    }

    public String getFetchedFrom() {
        return this.fetchedFrom;
    }

    public boolean isSuccessful() {
        if (this.mergeResult != null) {
            return this.mergeResult.getMergeStatus().isSuccessful();
        }
        if (this.rebaseResult != null) {
            return this.rebaseResult.getStatus().isSuccessful();
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.fetchResult != null) {
            sb.append(this.fetchResult.toString());
        } else {
            sb.append("No fetch result");
        }
        sb.append("\n");
        if (this.mergeResult != null) {
            sb.append(this.mergeResult.toString());
        } else if (this.rebaseResult != null) {
            sb.append(this.rebaseResult.toString());
        } else {
            sb.append("No update result");
        }
        return sb.toString();
    }
}

