/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.api;

import io.cucumber.pro.shaded.org.eclipse.jgit.api.GitCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.GitAPIException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.JGitInternalException;
import io.cucumber.pro.shaded.org.eclipse.jgit.errors.MissingObjectException;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.AnyObjectId;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectId;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Ref;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.FIFORevQueue;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevCommit;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevObject;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevTag;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevWalk;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NameRevCommand
extends GitCommand<Map<ObjectId, String>> {
    private static final int COMMIT_TIME_SLOP = 86400;
    private static final int MERGE_COST = 65535;
    private final RevWalk walk;
    private final List<String> prefixes = new ArrayList<String>(2);
    private final List<ObjectId> revs = new ArrayList<ObjectId>(2);
    private List<Ref> refs;
    private int mergeCost = 65535;

    protected NameRevCommand(Repository repo) {
        super(repo);
        this.walk = new RevWalk(repo){

            @Override
            public NameRevCommit createCommit(AnyObjectId id) {
                return new NameRevCommit(id);
            }
        };
    }

    @Override
    public Map<ObjectId, String> call() throws GitAPIException {
        try {
            NameRevCommit c;
            HashMap<ObjectId, String> nonCommits = new HashMap<ObjectId, String>();
            FIFORevQueue pending = new FIFORevQueue();
            if (this.refs != null) {
                for (Ref ref : this.refs) {
                    this.addRef(ref, nonCommits, pending);
                }
            }
            this.addPrefixes(nonCommits, pending);
            int cutoff = this.minCommitTime() - 86400;
            while ((c = (NameRevCommit)pending.next()) != null) {
                if (c.getCommitTime() < cutoff) continue;
                for (int i = 0; i < c.getParentCount(); ++i) {
                    NameRevCommit p = (NameRevCommit)this.walk.parseCommit(c.getParent(i));
                    long cost = c.cost + (long)(i > 0 ? this.mergeCost : 1);
                    if (p.tip != null && this.compare(c.tip, cost, p.tip, p.cost) >= 0L) continue;
                    if (i > 0) {
                        p.tip = c.format().append('^').append(i + 1).toString();
                        p.distance = 0;
                    } else {
                        p.tip = c.tip;
                        p.distance = c.distance + 1;
                    }
                    p.cost = cost;
                    pending.add(p);
                }
            }
            LinkedHashMap<ObjectId, String> result = new LinkedHashMap<ObjectId, String>(this.revs.size());
            for (ObjectId id : this.revs) {
                RevObject o = this.walk.parseAny(id);
                if (o instanceof NameRevCommit) {
                    NameRevCommit c2 = (NameRevCommit)o;
                    if (c2.tip == null) continue;
                    result.put(id, NameRevCommand.simplify(c2.format().toString()));
                    continue;
                }
                String name = (String)nonCommits.get(id);
                if (name == null) continue;
                result.put(id, NameRevCommand.simplify(name));
            }
            this.setCallable(false);
            LinkedHashMap<ObjectId, String> linkedHashMap = result;
            return linkedHashMap;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        finally {
            this.walk.close();
        }
    }

    public NameRevCommand add(ObjectId id) throws MissingObjectException, JGitInternalException {
        this.checkCallable();
        try {
            this.walk.parseAny(id);
        }
        catch (MissingObjectException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        this.revs.add(id.copy());
        return this;
    }

    public NameRevCommand add(Iterable<ObjectId> ids) throws MissingObjectException, JGitInternalException {
        for (ObjectId id : ids) {
            this.add(id);
        }
        return this;
    }

    public NameRevCommand addPrefix(String prefix) {
        this.checkCallable();
        this.prefixes.add(prefix);
        return this;
    }

    public NameRevCommand addAnnotatedTags() {
        this.checkCallable();
        if (this.refs == null) {
            this.refs = new ArrayList<Ref>();
        }
        try {
            for (Ref ref : this.repo.getRefDatabase().getRefs("refs/tags/").values()) {
                ObjectId id = ref.getObjectId();
                if (id == null || !(this.walk.parseAny(id) instanceof RevTag)) continue;
                this.addRef(ref);
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        return this;
    }

    public NameRevCommand addRef(Ref ref) {
        this.checkCallable();
        if (this.refs == null) {
            this.refs = new ArrayList<Ref>();
        }
        this.refs.add(ref);
        return this;
    }

    NameRevCommand setMergeCost(int cost) {
        this.mergeCost = cost;
        return this;
    }

    private void addPrefixes(Map<ObjectId, String> nonCommits, FIFORevQueue pending) throws IOException {
        if (!this.prefixes.isEmpty()) {
            for (String prefix : this.prefixes) {
                this.addPrefix(prefix, nonCommits, pending);
            }
        } else if (this.refs == null) {
            this.addPrefix("refs/", nonCommits, pending);
        }
    }

    private void addPrefix(String prefix, Map<ObjectId, String> nonCommits, FIFORevQueue pending) throws IOException {
        for (Ref ref : this.repo.getRefDatabase().getRefs(prefix).values()) {
            this.addRef(ref, nonCommits, pending);
        }
    }

    private void addRef(Ref ref, Map<ObjectId, String> nonCommits, FIFORevQueue pending) throws IOException {
        if (ref.getObjectId() == null) {
            return;
        }
        RevObject o = this.walk.parseAny(ref.getObjectId());
        while (o instanceof RevTag) {
            RevTag t = (RevTag)o;
            nonCommits.put(o, ref.getName());
            o = t.getObject();
            this.walk.parseHeaders(o);
        }
        if (o instanceof NameRevCommit) {
            NameRevCommit c = (NameRevCommit)o;
            if (c.tip == null) {
                c.tip = ref.getName();
            }
            pending.add(c);
        } else if (!nonCommits.containsKey(o)) {
            nonCommits.put(o, ref.getName());
        }
    }

    private int minCommitTime() throws IOException {
        int min = Integer.MAX_VALUE;
        for (ObjectId id : this.revs) {
            RevCommit c;
            RevObject o = this.walk.parseAny(id);
            while (o instanceof RevTag) {
                o = ((RevTag)o).getObject();
                this.walk.parseHeaders(o);
            }
            if (!(o instanceof RevCommit) || (c = (RevCommit)o).getCommitTime() >= min) continue;
            min = c.getCommitTime();
        }
        return min;
    }

    private long compare(String leftTip, long leftCost, String rightTip, long rightCost) {
        long c = leftCost - rightCost;
        if (c != 0L || this.prefixes.isEmpty()) {
            return c;
        }
        int li = -1;
        int ri = -1;
        for (int i = 0; i < this.prefixes.size(); ++i) {
            String prefix = this.prefixes.get(i);
            if (li < 0 && leftTip.startsWith(prefix)) {
                li = i;
            }
            if (ri >= 0 || !rightTip.startsWith(prefix)) continue;
            ri = i;
        }
        return li - ri;
    }

    private static String simplify(String refName) {
        if (refName.startsWith("refs/heads/")) {
            return refName.substring("refs/heads/".length());
        }
        if (refName.startsWith("refs/tags/")) {
            return refName.substring("refs/tags/".length());
        }
        if (refName.startsWith("refs/")) {
            return refName.substring("refs/".length());
        }
        return refName;
    }

    private static class NameRevCommit
    extends RevCommit {
        private String tip;
        private int distance;
        private long cost;

        private NameRevCommit(AnyObjectId id) {
            super(id);
        }

        private StringBuilder format() {
            StringBuilder sb = new StringBuilder(this.tip);
            if (this.distance > 0) {
                sb.append('~').append(this.distance);
            }
            return sb;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('[');
            if (this.tip != null) {
                sb.append((CharSequence)this.format());
            } else {
                sb.append((Object)null);
            }
            sb.append(',').append(this.cost).append(']').append(' ').append(super.toString()).toString();
            return sb.toString();
        }
    }
}

