/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.revision;

import cucumber.runtime.CucumberException;
import io.cucumber.pro.Logger;
import io.cucumber.pro.revision.RevisionProvider;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import java.io.File;
import java.io.IOException;

public class GitRevisionProvider
implements RevisionProvider {
    private final Repository repository;

    public GitRevisionProvider(Logger logger) {
        File currentDirectory = new File(System.getProperty("user.dir"));
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        try {
            ((FileRepositoryBuilder)((FileRepositoryBuilder)builder.readEnvironment()).findGitDir(currentDirectory)).setMustExist(true);
            if (builder.getGitDir() == null) {
                throw new CucumberException(String.format("The current directory '%s' and none of its parent directories appear to have a '.git' directory", currentDirectory));
            }
            logger.log(Logger.Level.INFO, "Current directory: '%s', Git directory: '%s'", currentDirectory, builder.getGitDir().getAbsolutePath());
            this.repository = builder.build();
        }
        catch (IOException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    @Override
    public String getRevision() {
        try {
            return this.repository.exactRef("HEAD").getObjectId().getName();
        }
        catch (IOException e) {
            throw new CucumberException((Throwable)e);
        }
    }
}

