/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.results;

import io.cucumber.pro.Logger;
import io.cucumber.pro.config.Config;
import io.cucumber.pro.environment.CiDetection;
import io.cucumber.pro.environment.ProjectName;
import io.cucumber.pro.results.CucumberProResultsUrlBuilder;
import io.cucumber.pro.results.HTTPResultsPublisher;
import io.cucumber.pro.results.NullResultsPublisher;
import io.cucumber.pro.results.ResultsPublisher;
import io.cucumber.pro.revision.RevisionProvider;
import io.cucumber.pro.revision.RevisionProviderFactory;

public class ResultsPublisherFactory {
    public static ResultsPublisher create(Config config, Logger logger) {
        boolean explicitPublish;
        boolean bl = explicitPublish = !config.isNull("cucumberpro.results.publish") && config.getBoolean("cucumberpro.results.publish") != false;
        if (new CiDetection(config).isRunningInCi() || explicitPublish) {
            String projectName = new ProjectName(config).getProjectName();
            RevisionProvider revisionProvider = RevisionProviderFactory.create(config, logger);
            String revision = revisionProvider.getRevision();
            String url = CucumberProResultsUrlBuilder.buildCucumberProUrl(config, projectName, revision);
            return new HTTPResultsPublisher(url, config, logger);
        }
        return new NullResultsPublisher(logger, null);
    }
}

