/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.transport;

import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectId;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.PreUploadHook;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.ServiceMayNotContinueException;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.UploadPack;
import java.util.Collection;
import java.util.List;

public class PreUploadHookChain
implements PreUploadHook {
    private final PreUploadHook[] hooks;
    private final int count;

    public static PreUploadHook newChain(List<? extends PreUploadHook> hooks) {
        PreUploadHook[] newHooks = new PreUploadHook[hooks.size()];
        int i = 0;
        for (PreUploadHook preUploadHook : hooks) {
            if (preUploadHook == PreUploadHook.NULL) continue;
            newHooks[i++] = preUploadHook;
        }
        if (i == 0) {
            return PreUploadHook.NULL;
        }
        if (i == 1) {
            return newHooks[0];
        }
        return new PreUploadHookChain(newHooks, i);
    }

    @Override
    public void onBeginNegotiateRound(UploadPack up, Collection<? extends ObjectId> wants, int cntOffered) throws ServiceMayNotContinueException {
        for (int i = 0; i < this.count; ++i) {
            this.hooks[i].onBeginNegotiateRound(up, wants, cntOffered);
        }
    }

    @Override
    public void onEndNegotiateRound(UploadPack up, Collection<? extends ObjectId> wants, int cntCommon, int cntNotFound, boolean ready) throws ServiceMayNotContinueException {
        for (int i = 0; i < this.count; ++i) {
            this.hooks[i].onEndNegotiateRound(up, wants, cntCommon, cntNotFound, ready);
        }
    }

    @Override
    public void onSendPack(UploadPack up, Collection<? extends ObjectId> wants, Collection<? extends ObjectId> haves) throws ServiceMayNotContinueException {
        for (int i = 0; i < this.count; ++i) {
            this.hooks[i].onSendPack(up, wants, haves);
        }
    }

    private PreUploadHookChain(PreUploadHook[] hooks, int count) {
        this.hooks = hooks;
        this.count = count;
    }
}

