/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.filter;

import io.cucumber.pro.shaded.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import io.cucumber.pro.shaded.org.eclipse.jgit.errors.MissingObjectException;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevCommit;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevWalk;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.filter.RevFilter;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.RawCharSequence;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.RawSubStringPattern;
import java.io.IOException;

public abstract class SubStringRevFilter
extends RevFilter {
    private final RawSubStringPattern pattern;

    public static boolean safe(String pattern) {
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    return false;
                }
            }
        }
        return true;
    }

    protected SubStringRevFilter(String patternText) {
        this.pattern = new RawSubStringPattern(patternText);
    }

    @Override
    public boolean include(RevWalk walker, RevCommit cmit) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.pattern.match(this.text(cmit)) >= 0;
    }

    @Override
    public boolean requiresCommitBody() {
        return true;
    }

    protected abstract RawCharSequence text(RevCommit var1);

    @Override
    public RevFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "(\"" + this.pattern.pattern() + "\")";
    }
}

