/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.revwalk;

import io.cucumber.pro.shaded.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import io.cucumber.pro.shaded.org.eclipse.jgit.errors.MissingObjectException;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Ref;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevCommit;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevObject;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevWalk;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class RevWalkUtils {
    private RevWalkUtils() {
    }

    public static int count(RevWalk walk, RevCommit start, RevCommit end) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return RevWalkUtils.find(walk, start, end).size();
    }

    public static List<RevCommit> find(RevWalk walk, RevCommit start, RevCommit end) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        walk.reset();
        walk.markStart(start);
        if (end != null) {
            walk.markUninteresting(end);
        }
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        for (RevCommit c : walk) {
            commits.add(c);
        }
        return commits;
    }

    public static List<Ref> findBranchesReachableFrom(RevCommit commit, RevWalk revWalk, Collection<Ref> refs) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        commit = revWalk.parseCommit(commit.getId());
        revWalk.reset();
        ArrayList<Ref> result = new ArrayList<Ref>();
        int SKEW = 86400;
        for (Ref ref : refs) {
            RevCommit headCommit;
            RevObject maybehead = revWalk.parseAny(ref.getObjectId());
            if (!(maybehead instanceof RevCommit) || (headCommit = (RevCommit)maybehead).getCommitTime() + 86400 < commit.getCommitTime() || !revWalk.isMergedInto(commit, headCommit)) continue;
            result.add(ref);
        }
        return result;
    }
}

