/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.lib;

import io.cucumber.pro.shaded.org.eclipse.jgit.errors.ConfigInvalidException;
import io.cucumber.pro.shaded.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import io.cucumber.pro.shaded.org.eclipse.jgit.errors.MissingObjectException;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.JGitText;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.AnyObjectId;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Config;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectId;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectLoader;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectReader;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevCommit;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevTree;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevWalk;
import io.cucumber.pro.shaded.org.eclipse.jgit.treewalk.TreeWalk;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.RawParseUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;

public class BlobBasedConfig
extends Config {
    public BlobBasedConfig(Config base, byte[] blob) throws ConfigInvalidException {
        super(base);
        String decoded = this.isUtf8(blob) ? RawParseUtils.decode(RawParseUtils.UTF8_CHARSET, blob, 3, blob.length) : RawParseUtils.decode(blob);
        this.fromText(decoded);
    }

    public BlobBasedConfig(Config base, Repository db, AnyObjectId objectId) throws IOException, ConfigInvalidException {
        this(base, BlobBasedConfig.read(db, objectId));
    }

    private static byte[] read(Repository db, AnyObjectId blobId) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        try (ObjectReader or = db.newObjectReader();){
            byte[] byArray = BlobBasedConfig.read(or, blobId);
            return byArray;
        }
    }

    private static byte[] read(ObjectReader or, AnyObjectId blobId) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader loader = or.open(blobId, 3);
        return loader.getCachedBytes(Integer.MAX_VALUE);
    }

    public BlobBasedConfig(Config base, Repository db, AnyObjectId treeish, String path) throws FileNotFoundException, IOException, ConfigInvalidException {
        this(base, BlobBasedConfig.read(db, treeish, path));
    }

    private static byte[] read(Repository db, AnyObjectId treeish, String path) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        try (ObjectReader or = db.newObjectReader();){
            TreeWalk tree = TreeWalk.forPath(or, path, BlobBasedConfig.asTree(or, treeish));
            if (tree == null) {
                throw new FileNotFoundException(MessageFormat.format(JGitText.get().entryNotFoundByPath, path));
            }
            byte[] byArray = BlobBasedConfig.read(or, (AnyObjectId)tree.getObjectId(0));
            return byArray;
        }
    }

    private static AnyObjectId asTree(ObjectReader or, AnyObjectId treeish) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (treeish instanceof RevTree) {
            return treeish;
        }
        if (treeish instanceof RevCommit && ((RevCommit)treeish).getTree() != null) {
            return ((RevCommit)treeish).getTree();
        }
        try (RevWalk rw = new RevWalk(or);){
            ObjectId objectId = rw.parseTree(treeish).getId();
            return objectId;
        }
    }
}

