/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file;

import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file.LockFile;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Constants;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.FS;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.FileUtils;
import java.io.File;
import java.io.IOException;

public class PackLock {
    private final File keepFile;

    public PackLock(File packFile, FS fs) {
        File p = packFile.getParentFile();
        String n = packFile.getName();
        this.keepFile = new File(p, n.substring(0, n.length() - 5) + ".keep");
    }

    public boolean lock(String msg) throws IOException {
        LockFile lf;
        if (msg == null) {
            return false;
        }
        if (!msg.endsWith("\n")) {
            msg = msg + "\n";
        }
        if (!(lf = new LockFile(this.keepFile)).lock()) {
            return false;
        }
        lf.write(Constants.encode(msg));
        return lf.commit();
    }

    public void unlock() throws IOException {
        FileUtils.delete(this.keepFile);
    }
}

