/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file;

import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file.PackFile;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.pack.StoredObjectRepresentation;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectId;
import java.io.IOException;

class LocalObjectRepresentation
extends StoredObjectRepresentation {
    PackFile pack;
    long offset;
    long length;
    private long baseOffset;
    private ObjectId baseId;

    LocalObjectRepresentation() {
    }

    static LocalObjectRepresentation newWhole(PackFile f, long p, long length) {
        LocalObjectRepresentation r = new LocalObjectRepresentation(){

            @Override
            public int getFormat() {
                return 1;
            }
        };
        r.pack = f;
        r.offset = p;
        r.length = length;
        return r;
    }

    static LocalObjectRepresentation newDelta(PackFile f, long p, long n, ObjectId base) {
        Delta r = new Delta();
        r.pack = f;
        r.offset = p;
        r.length = n;
        r.baseId = base;
        return r;
    }

    static LocalObjectRepresentation newDelta(PackFile f, long p, long n, long base) {
        Delta r = new Delta();
        r.pack = f;
        r.offset = p;
        r.length = n;
        r.baseOffset = base;
        return r;
    }

    @Override
    public int getWeight() {
        return (int)Math.min(this.length, Integer.MAX_VALUE);
    }

    @Override
    public ObjectId getDeltaBase() {
        if (this.baseId == null && this.getFormat() == 0) {
            try {
                this.baseId = this.pack.findObjectForOffset(this.baseOffset);
            }
            catch (IOException error) {
                return null;
            }
        }
        return this.baseId;
    }

    private static final class Delta
    extends LocalObjectRepresentation {
        private Delta() {
        }

        @Override
        public int getFormat() {
            return 0;
        }
    }
}

