/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.api;

import io.cucumber.pro.shaded.org.eclipse.jgit.api.CloneCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.FetchCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.Git;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.MergeCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.RebaseCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.TransportCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.CheckoutConflictException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.GitAPIException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.InvalidConfigurationException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.InvalidMergeHeadsException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.JGitInternalException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.NoHeadException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.NoMessageException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.RefNotFoundException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import io.cucumber.pro.shaded.org.eclipse.jgit.dircache.DirCacheCheckout;
import io.cucumber.pro.shaded.org.eclipse.jgit.errors.ConfigInvalidException;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ProgressMonitor;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.RefUpdate;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.merge.MergeStrategy;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevCommit;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevWalk;
import io.cucumber.pro.shaded.org.eclipse.jgit.submodule.SubmoduleWalk;
import io.cucumber.pro.shaded.org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class SubmoduleUpdateCommand
extends TransportCommand<SubmoduleUpdateCommand, Collection<String>> {
    private ProgressMonitor monitor;
    private final Collection<String> paths;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private CloneCommand.Callback callback;
    private FetchCommand.Callback fetchCallback;
    private boolean fetch = false;

    public SubmoduleUpdateCommand(Repository repo) {
        super(repo);
        this.paths = new ArrayList<String>();
    }

    public SubmoduleUpdateCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public SubmoduleUpdateCommand setFetch(boolean fetch) {
        this.fetch = fetch;
        return this;
    }

    public SubmoduleUpdateCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> call() throws InvalidConfigurationException, NoHeadException, ConcurrentRefUpdateException, CheckoutConflictException, InvalidMergeHeadsException, WrongRepositoryStateException, NoMessageException, NoHeadException, RefNotFoundException, GitAPIException {
        this.checkCallable();
        try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
            if (!this.paths.isEmpty()) {
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            ArrayList<String> updated = new ArrayList<String>();
            while (generator.next()) {
                block29: {
                    String url;
                    if (generator.getModulesPath() == null || (url = generator.getConfigUrl()) == null) continue;
                    Repository submoduleRepo = generator.getRepository();
                    if (submoduleRepo == null) {
                        if (this.callback != null) {
                            this.callback.cloningSubmodule(generator.getPath());
                        }
                        CloneCommand clone = Git.cloneRepository();
                        this.configure(clone);
                        clone.setURI(url);
                        clone.setDirectory(generator.getDirectory());
                        clone.setGitDir(new File(new File(this.repo.getDirectory(), "modules"), generator.getPath()));
                        if (this.monitor != null) {
                            clone.setProgressMonitor(this.monitor);
                        }
                        submoduleRepo = clone.call().getRepository();
                    } else if (this.fetch) {
                        if (this.fetchCallback != null) {
                            this.fetchCallback.fetchingSubmodule(generator.getPath());
                        }
                        FetchCommand fetchCommand = Git.wrap(submoduleRepo).fetch();
                        if (this.monitor != null) {
                            fetchCommand.setProgressMonitor(this.monitor);
                        }
                        this.configure(fetchCommand);
                        fetchCommand.call();
                    }
                    try (RevWalk walk = new RevWalk(submoduleRepo);){
                        RevCommit commit = walk.parseCommit(generator.getObjectId());
                        String update = generator.getConfigUpdate();
                        if ("merge".equals(update)) {
                            MergeCommand merge = new MergeCommand(submoduleRepo);
                            merge.include(commit);
                            merge.setProgressMonitor(this.monitor);
                            merge.setStrategy(this.strategy);
                            merge.call();
                            break block29;
                        }
                        if ("rebase".equals(update)) {
                            RebaseCommand rebase = new RebaseCommand(submoduleRepo);
                            rebase.setUpstream(commit);
                            rebase.setProgressMonitor(this.monitor);
                            rebase.setStrategy(this.strategy);
                            rebase.call();
                            break block29;
                        }
                        DirCacheCheckout co = new DirCacheCheckout(submoduleRepo, submoduleRepo.lockDirCache(), commit.getTree());
                        co.setFailOnConflict(true);
                        co.checkout();
                        RefUpdate refUpdate = submoduleRepo.updateRef("HEAD", true);
                        refUpdate.setNewObjectId(commit);
                        refUpdate.forceUpdate();
                        if (this.callback != null) {
                            this.callback.checkingOut(commit, generator.getPath());
                        }
                    }
                    finally {
                        submoduleRepo.close();
                    }
                }
                updated.add(generator.getPath());
            }
            ArrayList<String> arrayList = updated;
            return arrayList;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
    }

    public SubmoduleUpdateCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public SubmoduleUpdateCommand setCallback(CloneCommand.Callback callback) {
        this.callback = callback;
        return this;
    }

    public SubmoduleUpdateCommand setFetchCallback(FetchCommand.Callback callback) {
        this.fetchCallback = callback;
        return this;
    }
}

