/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.api;

import io.cucumber.pro.shaded.org.eclipse.jgit.api.GitCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.DetachedHeadException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.GitAPIException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.InvalidRefNameException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.JGitInternalException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.NoHeadException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.RefNotFoundException;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.JGitText;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectId;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Ref;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.RefRename;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.RefUpdate;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.StoredConfig;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;

public class RenameBranchCommand
extends GitCommand<Ref> {
    private String oldName;
    private String newName;

    protected RenameBranchCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Ref call() throws GitAPIException, RefNotFoundException, InvalidRefNameException, RefAlreadyExistsException, DetachedHeadException {
        this.checkCallable();
        if (this.newName == null) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, "<null>"));
        }
        try {
            Ref resultRef;
            String fullOldName;
            if (this.repo.findRef(this.newName) != null) {
                throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().refAlreadyExists1, this.newName));
            }
            if (this.oldName != null) {
                Ref ref = this.repo.findRef(this.oldName);
                if (ref == null) {
                    throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.oldName));
                }
                if (ref.getName().startsWith("refs/tags/")) {
                    throw new RefNotFoundException(MessageFormat.format(JGitText.get().renameBranchFailedBecauseTag, this.oldName));
                }
                fullOldName = ref.getName();
            } else {
                fullOldName = this.repo.getFullBranch();
                if (fullOldName == null) {
                    throw new NoHeadException(JGitText.get().invalidRepositoryStateNoHead);
                }
                if (ObjectId.isId(fullOldName)) {
                    throw new DetachedHeadException();
                }
            }
            String fullNewName = fullOldName.startsWith("refs/remotes/") ? "refs/remotes/" + this.newName : "refs/heads/" + this.newName;
            if (!Repository.isValidRefName(fullNewName)) {
                throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, fullNewName));
            }
            RefRename rename = this.repo.renameRef(fullOldName, fullNewName);
            RefUpdate.Result renameResult = rename.rename();
            this.setCallable(false);
            if (RefUpdate.Result.RENAMED != renameResult) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().renameBranchUnexpectedResult, renameResult.name()));
            }
            if (fullNewName.startsWith("refs/heads/")) {
                String shortOldName = fullOldName.substring("refs/heads/".length());
                StoredConfig repoConfig = this.repo.getConfig();
                for (String name : repoConfig.getNames("branch", shortOldName)) {
                    String[] values = repoConfig.getStringList("branch", shortOldName, name);
                    if (values.length == 0) continue;
                    String[] existing = repoConfig.getStringList("branch", this.newName, name);
                    if (existing.length > 0) {
                        String[] newValues = new String[values.length + existing.length];
                        System.arraycopy(existing, 0, newValues, 0, existing.length);
                        System.arraycopy(values, 0, newValues, existing.length, values.length);
                        values = newValues;
                    }
                    repoConfig.setStringList("branch", this.newName, name, Arrays.asList(values));
                }
                repoConfig.unsetSection("branch", shortOldName);
                repoConfig.save();
            }
            if ((resultRef = this.repo.findRef(this.newName)) == null) {
                throw new JGitInternalException(JGitText.get().renameBranchFailedUnknownReason);
            }
            return resultRef;
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
    }

    public RenameBranchCommand setNewName(String newName) {
        this.checkCallable();
        this.newName = newName;
        return this;
    }

    public RenameBranchCommand setOldName(String oldName) {
        this.checkCallable();
        this.oldName = oldName;
        return this;
    }
}

