/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.results;

import io.cucumber.pro.Env;
import io.cucumber.pro.URITemplate;
import java.util.HashMap;
import java.util.Map;

class CucumberProResultsUrlBuilder {
    private static final String DEFAULT_CUCUMBER_PRO_URL = "https://app.cucumber.pro/";

    CucumberProResultsUrlBuilder() {
    }

    static String buildCucumberProUrl(final Env env, final String projectName, final String revision) {
        String template = "{cucumberProUrl}tests/results/{projectName}/{revision}";
        URITemplate uriTemplate = new URITemplate(template);
        return uriTemplate.expand((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("cucumberProUrl", CucumberProResultsUrlBuilder.getCucumberProUrl(env));
                this.put("projectName", projectName);
                this.put("revision", revision);
            }
        });
    }

    private static String getCucumberProUrl(Env env) {
        String cucumberProUrl = env.get("CUCUMBER_PRO_BASE_URL", DEFAULT_CUCUMBER_PRO_URL);
        if (!cucumberProUrl.endsWith("/")) {
            cucumberProUrl = cucumberProUrl + "/";
        }
        return cucumberProUrl;
    }
}

