/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro;

import cucumber.api.event.Event;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.api.formatter.Formatter;
import cucumber.runtime.CucumberException;
import cucumber.runtime.formatter.PluginFactory;
import io.cucumber.pro.Env;
import io.cucumber.pro.EnvFactory;
import io.cucumber.pro.FilteredEnv;
import io.cucumber.pro.Logger;
import io.cucumber.pro.documentation.DocumentationPublisher;
import io.cucumber.pro.documentation.DocumentationPublisherFactory;
import io.cucumber.pro.results.ResultsPublisher;
import io.cucumber.pro.results.ResultsPublisherFactory;
import java.io.File;
import java.io.IOException;

public class JsonReporter
implements Formatter {
    static final String DEFAULT_CUCUMBER_PROFILE_NAME = "cucumber-jvm-unspecified-profile";
    private static final Env ENV = EnvFactory.create(System.getenv());
    private static final Logger LOGGER = new Logger.SystemLogger(ENV);
    private final Formatter jsonFormatter;
    private final File jsonFile;
    private final FilteredEnv filteredEnv;
    private final ResultsPublisher resultsPublisher;
    private final String profileName;
    private final DocumentationPublisher documentationPublisher;

    JsonReporter(DocumentationPublisher documentationPublisher, ResultsPublisher resultsPublisher, Env env, String profileName) {
        this.documentationPublisher = documentationPublisher;
        this.resultsPublisher = resultsPublisher;
        this.profileName = profileName;
        try {
            this.jsonFile = File.createTempFile("cucumber-json", ".json");
        }
        catch (IOException e) {
            throw new CucumberException((Throwable)e);
        }
        this.jsonFile.deleteOnExit();
        this.jsonFormatter = (Formatter)new PluginFactory().create("json:" + this.jsonFile.getAbsolutePath());
        this.filteredEnv = new FilteredEnv(env);
        System.out.println("Cucumber Pro Plugin Environment:\n" + this.filteredEnv);
    }

    public JsonReporter(String profileName) {
        this(DocumentationPublisherFactory.create(ENV, LOGGER), ResultsPublisherFactory.create(ENV, LOGGER), ENV, profileName);
    }

    public JsonReporter() {
        this(ENV.get("CUCUMBER_PROFILE_NAME", DEFAULT_CUCUMBER_PROFILE_NAME));
    }

    public void setEventPublisher(EventPublisher publisher) {
        if (this.jsonFormatter == null) {
            return;
        }
        this.jsonFormatter.setEventPublisher((EventPublisher)new PublisherAdapter(publisher));
    }

    private class PublisherAdapter
    implements EventPublisher {
        private final EventPublisher publisher;

        PublisherAdapter(EventPublisher publisher) {
            this.publisher = publisher;
        }

        public <T extends Event> void registerHandlerFor(Class<T> eventType, EventHandler<T> handler) {
            this.publisher.registerHandlerFor(eventType, handler);
            if (eventType == TestRunFinished.class) {
                this.publisher.registerHandlerFor(TestRunFinished.class, (EventHandler)new EventHandler<TestRunFinished>(){

                    public void receive(TestRunFinished event) {
                        JsonReporter.this.documentationPublisher.publish();
                        JsonReporter.this.resultsPublisher.publish(JsonReporter.this.jsonFile, JsonReporter.this.filteredEnv.toString(), JsonReporter.this.profileName);
                    }
                });
            }
        }
    }
}

