/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.prettyformatter;

import java.util.Comparator;

final class OrderableMessage<T>
implements Comparable<OrderableMessage<T>> {
    private final T message;
    private final String uri;
    private final Long line;
    private final Comparator<OrderableMessage<T>> comparator = Comparator.comparing(ord -> ord.uri, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(ord -> ord.line, Comparator.nullsFirst(Comparator.naturalOrder()));

    OrderableMessage(T message, String uri, Long line) {
        this.message = message;
        this.uri = uri;
        this.line = line;
    }

    @Override
    public int compareTo(OrderableMessage<T> o) {
        return this.comparator.compare(this, o);
    }

    T getMessage() {
        return this.message;
    }
}

