/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.datatable;

import io.cucumber.datatable.DiffTablePrinter;
import io.cucumber.datatable.DiffType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;

class DataTableDiff {
    private final List<List<String>> table;
    private final List<DiffType> diffTypes;

    static DataTableDiff create(List<AbstractMap.SimpleEntry<List<String>, DiffType>> diffTableRows) {
        ArrayList<DiffType> diffTypes = new ArrayList<DiffType>(diffTableRows.size());
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        for (AbstractMap.SimpleEntry<List<String>, DiffType> row : diffTableRows) {
            table.add(row.getKey());
            diffTypes.add(row.getValue());
        }
        return new DataTableDiff(table, diffTypes);
    }

    private DataTableDiff(List<List<String>> table, List<DiffType> diffTypes) {
        this.table = table;
        this.diffTypes = diffTypes;
    }

    boolean isEmpty() {
        return !this.diffTypes.contains((Object)DiffType.DELETE) && !this.diffTypes.contains((Object)DiffType.INSERT);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        DiffTablePrinter printer = new DiffTablePrinter(this.diffTypes);
        printer.printTable(this.table, result);
        return result.toString();
    }
}

