/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.junit.JUnitOptions;
import io.cucumber.junit.PickleRunners;
import io.cucumber.junit.SkippedThrowable;
import io.cucumber.junit.UndefinedStepException;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.SnippetsSuggestedEvent;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.MultipleFailureException;

final class JUnitReporter {
    private final JUnitOptions junitOptions;
    private final EventBus bus;
    private final Map<StepLocation, Collection<String>> snippetsPerStep = new TreeMap<StepLocation, Collection<String>>();
    private final EventHandler<SnippetsSuggestedEvent> snippetsSuggestedEventEventHandler = this::handleSnippetSuggested;
    private List<Throwable> stepErrors;
    private TestNotifier stepNotifier;
    private final EventHandler<TestStepFinished> testStepFinishedHandler = this::handleTestStepFinished;
    private PickleRunners.PickleRunner pickleRunner;
    private RunNotifier runNotifier;
    private final EventHandler<TestStepStarted> testStepStartedHandler = this::handTestStepStarted;
    private TestNotifier pickleRunnerNotifier;
    private final EventHandler<TestCaseStarted> testCaseStartedHandler = this::handleTestCaseStarted;
    private final EventHandler<TestCaseFinished> testCaseFinishedHandler = this::handleTestCaseResult;

    JUnitReporter(EventBus bus, JUnitOptions junitOption) {
        this.junitOptions = junitOption;
        this.bus = bus;
        bus.registerHandlerFor(TestCaseStarted.class, this.testCaseStartedHandler);
        bus.registerHandlerFor(TestStepStarted.class, this.testStepStartedHandler);
        bus.registerHandlerFor(TestStepFinished.class, this.testStepFinishedHandler);
        bus.registerHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
        bus.registerHandlerFor(SnippetsSuggestedEvent.class, this.snippetsSuggestedEventEventHandler);
    }

    private void handleSnippetSuggested(SnippetsSuggestedEvent snippetsSuggestedEvent) {
        this.snippetsPerStep.putIfAbsent(new StepLocation(snippetsSuggestedEvent.getUri(), snippetsSuggestedEvent.getStepLine()), snippetsSuggestedEvent.getSnippets());
    }

    void finishExecutionUnit() {
        this.bus.removeHandlerFor(TestCaseStarted.class, this.testCaseStartedHandler);
        this.bus.removeHandlerFor(TestStepStarted.class, this.testStepStartedHandler);
        this.bus.removeHandlerFor(TestStepFinished.class, this.testStepFinishedHandler);
        this.bus.removeHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
        this.bus.removeHandlerFor(SnippetsSuggestedEvent.class, this.snippetsSuggestedEventEventHandler);
    }

    void startExecutionUnit(PickleRunners.PickleRunner pickleRunner, RunNotifier runNotifier) {
        this.pickleRunner = pickleRunner;
        this.runNotifier = runNotifier;
        this.stepNotifier = null;
        this.pickleRunnerNotifier = new EachTestNotifier(runNotifier, pickleRunner.getDescription());
    }

    private void handleTestCaseStarted(TestCaseStarted testCaseStarted) {
        this.stepErrors = new ArrayList<Throwable>();
    }

    private void handTestStepStarted(TestStepStarted event) {
        TestStep testStep = event.getTestStep();
        if (testStep instanceof PickleStepTestStep) {
            PickleStepTestStep pickleStep = (PickleStepTestStep)testStep;
            if (this.junitOptions.stepNotifications()) {
                Description description = this.pickleRunner.describeChild(pickleStep.getStep());
                this.stepNotifier = new EachTestNotifier(this.runNotifier, description);
            } else {
                this.stepNotifier = new NoTestNotifier();
            }
            this.stepNotifier.fireTestStarted();
        }
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (event.getTestStep() instanceof PickleStepTestStep) {
            PickleStepTestStep testStep = (PickleStepTestStep)event.getTestStep();
            this.handleStepResult(testStep, event.getResult());
        } else {
            this.handleHookResult(event.getResult());
        }
    }

    private void handleStepResult(PickleStepTestStep testStep, Result result) {
        Throwable error = result.getError();
        switch (result.getStatus()) {
            case PASSED: {
                break;
            }
            case SKIPPED: {
                if (error == null) {
                    error = new SkippedThrowable(SkippedThrowable.NotificationLevel.STEP);
                } else {
                    this.stepErrors.add(error);
                }
                this.stepNotifier.addFailedAssumption(error);
                break;
            }
            case PENDING: 
            case AMBIGUOUS: 
            case FAILED: {
                this.stepErrors.add(error);
                this.stepNotifier.addFailure(error);
                break;
            }
            case UNDEFINED: {
                Collection<String> snippets = this.snippetsPerStep.remove(new StepLocation(testStep.getUri(), testStep.getStepLine()));
                this.stepErrors.add(new UndefinedStepException(testStep.getStepText(), snippets, this.snippetsPerStep.values()));
                this.stepNotifier.addFailure(error == null ? new UndefinedStepException(snippets) : error);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected result status: " + result.getStatus());
            }
        }
        this.stepNotifier.fireTestFinished();
    }

    private void handleTestCaseResult(TestCaseFinished event) {
        Result result = event.getResult();
        switch (result.getStatus()) {
            case PASSED: {
                break;
            }
            case SKIPPED: {
                if (this.stepErrors.isEmpty()) {
                    this.stepErrors.add(new SkippedThrowable(SkippedThrowable.NotificationLevel.SCENARIO));
                }
                this.stepErrors.stream().findFirst().ifPresent(this.pickleRunnerNotifier::addFailedAssumption);
                break;
            }
            case PENDING: 
            case UNDEFINED: {
                this.stepErrors.stream().findFirst().ifPresent(this.pickleRunnerNotifier::addFailure);
                break;
            }
            case AMBIGUOUS: 
            case FAILED: {
                this.stepErrors.forEach(this.pickleRunnerNotifier::addFailure);
            }
        }
    }

    private void handleHookResult(Result result) {
        if (result.getError() != null) {
            this.stepErrors.add(result.getError());
        }
    }

    static class EachTestNotifier
    implements TestNotifier {
        private final RunNotifier notifier;
        private final Description description;

        EachTestNotifier(RunNotifier notifier, Description description) {
            this.notifier = notifier;
            this.description = description;
        }

        @Override
        public void addFailure(Throwable targetException) {
            if (targetException instanceof MultipleFailureException) {
                this.addMultipleFailureException((MultipleFailureException)targetException);
            } else {
                this.notifier.fireTestFailure(new Failure(this.description, targetException));
            }
        }

        private void addMultipleFailureException(MultipleFailureException mfe) {
            for (Throwable each : mfe.getFailures()) {
                this.addFailure(each);
            }
        }

        @Override
        public void addFailedAssumption(Throwable e) {
            this.notifier.fireTestAssumptionFailed(new Failure(this.description, e));
        }

        @Override
        public void fireTestFinished() {
            this.notifier.fireTestFinished(this.description);
        }

        @Override
        public void fireTestStarted() {
            this.notifier.fireTestStarted(this.description);
        }
    }

    static final class NoTestNotifier
    implements TestNotifier {
        NoTestNotifier() {
        }

        @Override
        public void fireTestStarted() {
        }

        @Override
        public void addFailure(Throwable error) {
        }

        @Override
        public void addFailedAssumption(Throwable error) {
        }

        @Override
        public void fireTestFinished() {
        }
    }

    private static final class StepLocation
    implements Comparable<StepLocation> {
        private final URI uri;
        private final int line;

        private StepLocation(URI uri, int line) {
            this.uri = uri;
            this.line = line;
        }

        @Override
        public int compareTo(StepLocation o) {
            int order = this.uri.compareTo(o.uri);
            return order != 0 ? order : Integer.compare(this.line, o.line);
        }
    }

    private static interface TestNotifier {
        public void fireTestStarted();

        public void addFailure(Throwable var1);

        public void addFailedAssumption(Throwable var1);

        public void fireTestFinished();
    }
}

