/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.eventbus.Options;
import io.cucumber.core.eventbus.UuidGenerator;
import io.cucumber.core.feature.FeatureIdentifier;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.resource.ClassLoaders;
import io.cucumber.core.resource.ResourceScanner;
import io.cucumber.core.runtime.UuidGeneratorServiceLoader;
import io.cucumber.junit.platform.engine.Cucumber;
import io.cucumber.junit.platform.engine.CucumberConfiguration;
import io.cucumber.junit.platform.engine.CucumberDiscoverySelectors;
import io.cucumber.junit.platform.engine.CucumberTestDescriptor;
import io.cucumber.junit.platform.engine.FeatureOrigin;
import io.cucumber.junit.platform.engine.FeatureParserWithCaching;
import io.cucumber.junit.platform.engine.FeatureParserWithIssueReporting;
import io.cucumber.junit.platform.engine.NamingStrategy;
import io.cucumber.plugin.event.Node;
import java.net.URI;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.commons.support.Resource;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.discovery.UriSelector;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;
import org.junit.platform.engine.support.discovery.SelectorResolver;

final class FeatureResolver
implements SelectorResolver {
    private final ResourceScanner<Feature> featureScanner;
    private final CucumberConfiguration configuration;
    private final FeatureParserWithCaching featureParser;
    private final Predicate<String> packageFilter;
    private final DiscoveryIssueReporter issueReporter;

    FeatureResolver(CucumberConfiguration configuration, Predicate<String> packageFilter, DiscoveryIssueReporter issueReporter) {
        this.configuration = configuration;
        this.packageFilter = packageFilter;
        this.issueReporter = issueReporter;
        this.featureParser = FeatureResolver.createFeatureParser(configuration, issueReporter);
        this.featureScanner = new ResourceScanner(ClassLoaders::getDefaultClassLoader, FeatureIdentifier::isFeature, this.featureParser::parseResource);
    }

    private static FeatureParserWithCaching createFeatureParser(CucumberConfiguration options, DiscoveryIssueReporter issueReporter) {
        Supplier<ClassLoader> classLoader = FeatureResolver.class::getClassLoader;
        UuidGeneratorServiceLoader uuidGeneratorServiceLoader = new UuidGeneratorServiceLoader(classLoader, (Options)options);
        UuidGenerator uuidGenerator = uuidGeneratorServiceLoader.loadUuidGenerator();
        FeatureParser featureParser = new FeatureParser(() -> ((UuidGenerator)uuidGenerator).generateId());
        FeatureParserWithIssueReporting featureParserWithIssueReporting = new FeatureParserWithIssueReporting(featureParser, issueReporter);
        return new FeatureParserWithCaching(featureParserWithIssueReporting);
    }

    public SelectorResolver.Resolution resolve(DiscoverySelector selector, SelectorResolver.Context context) {
        if (selector instanceof CucumberDiscoverySelectors.FeatureElementSelector) {
            return this.resolve((CucumberDiscoverySelectors.FeatureElementSelector)selector, context);
        }
        if (selector instanceof CucumberDiscoverySelectors.FeatureWithLinesSelector) {
            return this.resolve((CucumberDiscoverySelectors.FeatureWithLinesSelector)selector);
        }
        return super.resolve(selector, context);
    }

    public SelectorResolver.Resolution resolve(CucumberDiscoverySelectors.FeatureElementSelector selector, SelectorResolver.Context context) {
        Feature feature = selector.getFeature();
        Node selected = selector.getElement();
        return selected.getParent().map(parent -> context.addToParent(() -> CucumberDiscoverySelectors.FeatureElementSelector.selectElement(feature, parent), this.createTestDescriptor(feature, selected))).orElseGet(() -> context.addToParent(this.createTestDescriptor(feature, selected))).map(descriptor -> SelectorResolver.Match.exact((TestDescriptor)descriptor, () -> CucumberDiscoverySelectors.FeatureElementSelector.selectElementsOf(feature, selected))).map(SelectorResolver.Resolution::match).orElseGet(SelectorResolver.Resolution::unresolved);
    }

    public SelectorResolver.Resolution resolve(CucumberDiscoverySelectors.FeatureWithLinesSelector selector) {
        URI uri = selector.getUri();
        Set selectors = this.featureScanner.scanForResourcesUri(uri).stream().flatMap(feature -> selector.getFilePositions().map(filePositions -> filePositions.stream().map(position -> CucumberDiscoverySelectors.FeatureElementSelector.selectElementAt(feature, position)).filter(Optional::isPresent).map(Optional::get)).orElseGet(() -> Stream.of(CucumberDiscoverySelectors.FeatureElementSelector.selectFeature(feature)))).collect(Collectors.toSet());
        return FeatureResolver.toResolution(selectors);
    }

    public SelectorResolver.Resolution resolve(FileSelector selector, SelectorResolver.Context context) {
        Set selectors = this.featureParser.parseResource(selector.getPath()).flatMap(feature -> selector.getPosition().map(position -> CucumberDiscoverySelectors.FeatureElementSelector.selectElementAt(feature, position)).orElseGet(() -> Optional.of(CucumberDiscoverySelectors.FeatureElementSelector.selectFeature(feature)))).map(Collections::singleton).orElseGet(Collections::emptySet);
        return FeatureResolver.toResolution(selectors);
    }

    public SelectorResolver.Resolution resolve(ClasspathResourceSelector selector, SelectorResolver.Context context) {
        Set resources = selector.getClasspathResources();
        if (!resources.stream().allMatch(resource -> FeatureIdentifier.isFeature((String)resource.getName()))) {
            return this.resolveClasspathResourceSelectorAsPackageSelector(selector);
        }
        if (resources.size() > 1) {
            throw new IllegalArgumentException(String.format("Found %s resources named %s on the classpath %s.", resources.size(), selector.getClasspathResourceName(), resources.stream().map(Resource::getUri).collect(Collectors.toList())));
        }
        return resources.stream().findFirst().flatMap(this.featureParser::parseResource).map(feature -> selector.getPosition().map(position -> CucumberDiscoverySelectors.FeatureElementSelector.selectElementAt(feature, position)).orElseGet(() -> Optional.of(CucumberDiscoverySelectors.FeatureElementSelector.selectFeature(feature)))).filter(Optional::isPresent).map(Optional::get).map(Collections::singleton).map(FeatureResolver::toResolution).orElseGet(SelectorResolver.Resolution::unresolved);
    }

    @Deprecated
    private SelectorResolver.Resolution resolveClasspathResourceSelectorAsPackageSelector(ClasspathResourceSelector selector) {
        Set selectors = this.featureScanner.scanForClasspathResource(selector.getClasspathResourceName(), this.packageFilter).stream().map(feature -> selector.getPosition().map(position -> CucumberDiscoverySelectors.FeatureElementSelector.selectElementAt(feature, position)).orElseGet(() -> Optional.of(CucumberDiscoverySelectors.FeatureElementSelector.selectFeature(feature)))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        this.warnClasspathResourceSelectorUsedForPackage(selector);
        return FeatureResolver.toResolution(selectors);
    }

    private void warnClasspathResourceSelectorUsedForPackage(ClasspathResourceSelector selector) {
        String classpathResourceName = selector.getClasspathResourceName();
        String packageName = classpathResourceName.replaceAll("/", ".");
        String message = String.format("The classpath resource selector '%s' should not be used to select features in a package. Use the package selector with '%s' instead", classpathResourceName, packageName);
        this.issueReporter.reportIssue(DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.WARNING, (String)message));
    }

    public SelectorResolver.Resolution resolve(UriSelector selector, SelectorResolver.Context context) {
        URI uri = selector.getUri();
        Set<CucumberDiscoverySelectors.FeatureWithLinesSelector> selectors = Collections.singleton(CucumberDiscoverySelectors.FeatureWithLinesSelector.from(uri));
        return FeatureResolver.toResolution(selectors);
    }

    public SelectorResolver.Resolution resolve(ClassSelector selector, SelectorResolver.Context context) {
        Class javaClass = selector.getJavaClass();
        Cucumber annotation = javaClass.getAnnotation(Cucumber.class);
        if (annotation != null) {
            this.warnAboutDeprecatedCucumberClass(javaClass);
            String packageName = javaClass.getPackage().getName();
            Set<PackageSelector> selectors = Collections.singleton(DiscoverySelectors.selectPackage((String)packageName));
            return FeatureResolver.toResolution(selectors);
        }
        return SelectorResolver.Resolution.unresolved();
    }

    private void warnAboutDeprecatedCucumberClass(Class<?> javaClass) {
        String message = "The @Cucumber annotation has been deprecated. See the Javadoc for more details.";
        DiscoveryIssue issue = DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.WARNING, (String)message).source((TestSource)ClassSource.from(javaClass)).build();
        this.issueReporter.reportIssue(issue);
    }

    public SelectorResolver.Resolution resolve(UniqueIdSelector selector, SelectorResolver.Context context) {
        UniqueId uniqueId = selector.getUniqueId();
        Set<CucumberDiscoverySelectors.FeatureWithLinesSelector> selectors = CucumberDiscoverySelectors.FeatureWithLinesSelector.from(uniqueId);
        return FeatureResolver.toResolution(selectors);
    }

    private Function<TestDescriptor, Optional<TestDescriptor>> createTestDescriptor(Feature feature, Node node) {
        return parent -> {
            NamingStrategy namingStrategy = this.configuration.namingStrategy();
            FeatureOrigin source = FeatureOrigin.fromUri(feature.getUri());
            String name = namingStrategy.name(node);
            TestSource testSource = source.nodeSource(node);
            if (node instanceof Node.Feature) {
                return Optional.of(new CucumberTestDescriptor.FeatureDescriptor(parent.getUniqueId().append("feature", feature.getUri().toString()), name, testSource, feature));
            }
            int line = node.getLocation().getLine();
            if (node instanceof Node.Rule) {
                return Optional.of(new CucumberTestDescriptor.FeatureElementDescriptor.RuleDescriptor(this.configuration, parent.getUniqueId().append("rule", String.valueOf(line)), name, testSource, node));
            }
            if (node instanceof Node.Scenario) {
                return Optional.of(new CucumberTestDescriptor.PickleDescriptor(this.configuration, parent.getUniqueId().append("scenario", String.valueOf(line)), name, testSource, feature.getPickleAt(node)));
            }
            if (node instanceof Node.ScenarioOutline) {
                return Optional.of(new CucumberTestDescriptor.FeatureElementDescriptor.ScenarioOutlineDescriptor(this.configuration, parent.getUniqueId().append("scenario", String.valueOf(line)), name, testSource, node));
            }
            if (node instanceof Node.Examples) {
                return Optional.of(new CucumberTestDescriptor.FeatureElementDescriptor.ExamplesDescriptor(this.configuration, parent.getUniqueId().append("examples", String.valueOf(line)), name, testSource, node));
            }
            if (node instanceof Node.Example) {
                Pickle pickle = feature.getPickleAt(node);
                return Optional.of(new CucumberTestDescriptor.PickleDescriptor(this.configuration, parent.getUniqueId().append("example", String.valueOf(line)), namingStrategy.nameExample(node, pickle), testSource, pickle));
            }
            throw new IllegalStateException("Got a " + node.getClass() + " but didn't have a case to handle it");
        };
    }

    private static SelectorResolver.Resolution toResolution(Set<? extends DiscoverySelector> selectors) {
        if (selectors.isEmpty()) {
            return SelectorResolver.Resolution.unresolved();
        }
        return SelectorResolver.Resolution.selectors(selectors);
    }
}

