/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.eventbus.UuidGenerator;
import io.cucumber.core.feature.FeatureWithLines;
import io.cucumber.core.feature.GluePath;
import io.cucumber.core.options.ObjectFactoryParser;
import io.cucumber.core.options.PluginOption;
import io.cucumber.core.options.SnippetTypeParser;
import io.cucumber.core.options.UuidGeneratorParser;
import io.cucumber.core.plugin.NoPublishFormatter;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.plugin.PublishFormatter;
import io.cucumber.core.snippets.SnippetType;
import io.cucumber.junit.platform.engine.CucumberDiscoverySelectors;
import io.cucumber.junit.platform.engine.DefaultNamingStrategyProvider;
import io.cucumber.junit.platform.engine.ExclusiveResourceConfiguration;
import io.cucumber.junit.platform.engine.NamingStrategy;
import io.cucumber.tagexpressions.Expression;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.support.config.PrefixedConfigurationParameters;
import org.junit.platform.engine.support.hierarchical.Node;

class CucumberConfiguration
implements Options,
io.cucumber.core.runner.Options,
io.cucumber.core.backend.Options,
io.cucumber.core.eventbus.Options {
    private final ConfigurationParameters configurationParameters;

    CucumberConfiguration(ConfigurationParameters configurationParameters) {
        this.configurationParameters = Objects.requireNonNull(configurationParameters);
    }

    public List<Options.Plugin> plugins() {
        List plugins = this.configurationParameters.get("cucumber.plugin", s -> Arrays.stream(s.split(",")).map(String::trim).map(PluginOption::parse).map(pluginOption -> pluginOption).collect(Collectors.toList())).orElseGet(ArrayList::new);
        this.getPublishPlugin().ifPresent(plugins::add);
        return plugins;
    }

    private Optional<PluginOption> getPublishPlugin() {
        if (this.isPublishPluginEnabled()) {
            return this.createPublishPlugin();
        }
        return this.createCucumberReportsAdvertisingPlugin();
    }

    private Optional<PluginOption> createCucumberReportsAdvertisingPlugin() {
        Optional<PluginOption> noPublishOption = Optional.of(PluginOption.forClass(NoPublishFormatter.class));
        Optional quiteOption = Optional.empty();
        return this.configurationParameters.getBoolean("cucumber.publish.quiet").map(quite -> quite != false ? quiteOption : noPublishOption).orElse(quiteOption);
    }

    private Optional<PluginOption> createPublishPlugin() {
        PluginOption publishPlugin = this.configurationParameters.get("cucumber.publish.token").map(token -> PluginOption.forClass(PublishFormatter.class, (String)token)).orElse(PluginOption.forClass(PublishFormatter.class));
        return Optional.of(publishPlugin);
    }

    private boolean isPublishPluginEnabled() {
        return this.configurationParameters.getBoolean("cucumber.publish.enabled").orElse(this.configurationParameters.get("cucumber.publish.token").isPresent());
    }

    public boolean isMonochrome() {
        return this.configurationParameters.getBoolean("cucumber.ansi-colors.disabled").orElse(false);
    }

    public boolean isWip() {
        return false;
    }

    Optional<Expression> tagFilter() {
        return this.configurationParameters.get("cucumber.filter.tags", TagExpressionParser::parse);
    }

    Optional<Pattern> nameFilter() {
        return this.configurationParameters.get("cucumber.filter.name", Pattern::compile);
    }

    public List<URI> getGlue() {
        return this.configurationParameters.get("cucumber.glue", s -> Arrays.asList(s.split(","))).orElse(Collections.singletonList("classpath:")).stream().map(String::trim).map(GluePath::parse).collect(Collectors.toList());
    }

    public boolean isDryRun() {
        return this.configurationParameters.getBoolean("cucumber.execution.dry-run").orElse(false);
    }

    public SnippetType getSnippetType() {
        return this.configurationParameters.get("cucumber.snippet-type", SnippetTypeParser::parseSnippetType).orElse(SnippetType.UNDERSCORE);
    }

    public Class<? extends ObjectFactory> getObjectFactoryClass() {
        return this.configurationParameters.get("cucumber.object-factory", ObjectFactoryParser::parseObjectFactory).orElse(null);
    }

    public Class<? extends UuidGenerator> getUuidGeneratorClass() {
        return this.configurationParameters.get("cucumber.uuid-generator", UuidGeneratorParser::parseUuidGenerator).orElse(null);
    }

    boolean isParallelExecutionEnabled() {
        return this.configurationParameters.getBoolean("cucumber.execution.parallel.enabled").orElse(false);
    }

    NamingStrategy namingStrategy() {
        return this.configurationParameters.get("cucumber.junit-platform.naming-strategy", DefaultNamingStrategyProvider::getStrategyProvider).orElse(DefaultNamingStrategyProvider.SHORT).create(this.configurationParameters);
    }

    Set<CucumberDiscoverySelectors.FeatureWithLinesSelector> featuresWithLines() {
        return this.configurationParameters.get("cucumber.features", s -> Arrays.stream(s.split(",")).map(String::trim).map(FeatureWithLines::parse).map(CucumberDiscoverySelectors.FeatureWithLinesSelector::from).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    Node.ExecutionMode getExecutionModeFeature() {
        return this.configurationParameters.get("cucumber.execution.execution-mode.feature", value -> Node.ExecutionMode.valueOf((String)value.toUpperCase(Locale.US))).orElse(Node.ExecutionMode.CONCURRENT);
    }

    ExclusiveResourceConfiguration getExclusiveResourceConfiguration(String tag) {
        Objects.requireNonNull(tag);
        return new ExclusiveResourceConfiguration((ConfigurationParameters)new PrefixedConfigurationParameters(this.configurationParameters, "cucumber.execution.exclusive-resources." + tag));
    }
}

