/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.jsonformatter;

import io.cucumber.jsonformatter.JsonReportWriter;
import io.cucumber.jsonformatter.RelativeUriFormatter;
import io.cucumber.messages.types.Envelope;
import io.cucumber.query.Query;
import io.cucumber.query.Repository;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class MessagesToJsonWriter
implements AutoCloseable {
    private final OutputStreamWriter out;
    private final Repository repository = Repository.builder().feature(Repository.RepositoryFeature.INCLUDE_ATTACHMENTS, true).feature(Repository.RepositoryFeature.INCLUDE_GHERKIN_DOCUMENTS, true).feature(Repository.RepositoryFeature.INCLUDE_HOOKS, true).feature(Repository.RepositoryFeature.INCLUDE_STEP_DEFINITIONS, true).build();
    private final Query query = new Query(this.repository);
    private final Serializer serializer;
    private final Function<URI, String> uriFormatter;
    private boolean streamClosed = false;

    private MessagesToJsonWriter(OutputStream out, Serializer serializer, Function<URI, String> uriFormatter) {
        this.out = new OutputStreamWriter(Objects.requireNonNull(out), StandardCharsets.UTF_8);
        this.serializer = Objects.requireNonNull(serializer);
        this.uriFormatter = Objects.requireNonNull(uriFormatter);
    }

    public static Builder builder(Serializer serializer) {
        return new Builder(serializer);
    }

    public void write(Envelope envelope) throws IOException {
        if (this.streamClosed) {
            throw new IOException("Stream closed");
        }
        this.repository.update(envelope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.streamClosed) {
            return;
        }
        try {
            List<Object> report = new JsonReportWriter(this.query, this.uriFormatter).createJsonReport();
            this.serializer.writeValue(this.out, report);
        }
        finally {
            try {
                this.out.close();
            }
            finally {
                this.streamClosed = true;
            }
        }
    }

    @FunctionalInterface
    public static interface Serializer {
        public void writeValue(Writer var1, Object var2) throws IOException;
    }

    public static final class Builder {
        private final Serializer serializer;
        private Function<URI, String> uriFormatter = URI::toString;

        private Builder(Serializer serializer) {
            this.serializer = Objects.requireNonNull(serializer);
        }

        public Builder relativizeAgainst(URI uri) {
            this.uriFormatter = new RelativeUriFormatter(uri).andThen(URI::toString);
            return this;
        }

        public MessagesToJsonWriter build(OutputStream out) {
            Objects.requireNonNull(out);
            return new MessagesToJsonWriter(out, this.serializer, this.uriFormatter);
        }
    }
}

