/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java8;

import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.core.backend.DataTableTypeDefinition;
import io.cucumber.core.backend.DefaultDataTableCellTransformerDefinition;
import io.cucumber.core.backend.DefaultDataTableEntryTransformerDefinition;
import io.cucumber.core.backend.DefaultParameterTransformerDefinition;
import io.cucumber.core.backend.DocStringTypeDefinition;
import io.cucumber.core.backend.Glue;
import io.cucumber.core.backend.HookDefinition;
import io.cucumber.core.backend.ParameterTypeDefinition;
import io.cucumber.core.backend.StepDefinition;
import io.cucumber.java8.AbstractGlueDefinition;
import io.cucumber.java8.Java8DataTableTypeDefinition;
import io.cucumber.java8.Java8DefaultDataTableCellTransformerDefinition;
import io.cucumber.java8.Java8DefaultDataTableEntryTransformerDefinition;
import io.cucumber.java8.Java8DefaultParameterTransformerDefinition;
import io.cucumber.java8.Java8DocStringTypeDefinition;
import io.cucumber.java8.Java8HookDefinition;
import io.cucumber.java8.Java8ParameterTypeDefinition;
import io.cucumber.java8.Java8StepDefinition;
import io.cucumber.java8.LambdaGlueRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

final class ClosureAwareGlueRegistry
implements LambdaGlueRegistry {
    private final List<AbstractGlueDefinition> definitions = new ArrayList<AbstractGlueDefinition>();
    private int registered;
    private int expectedRegistrations = -1;
    private final Glue glue;

    ClosureAwareGlueRegistry(Glue glue) {
        this.glue = glue;
    }

    void startRegistration() {
        this.registered = 0;
    }

    void finishRegistration() {
        if (this.expectedRegistrations < 0) {
            this.expectedRegistrations = this.registered;
        } else if (this.expectedRegistrations != this.registered) {
            throw new CucumberBackendException(String.format("Found an inconsistent number of glue registrations.\nPreviously %s step definitions, hooks and parameter types were registered. Currently %s.\nTo optimize performance Cucumber expects glue registration to be identical for each scenario and example.", this.expectedRegistrations, this.registered));
        }
    }

    @Override
    public void addStepDefinition(StepDefinition stepDefinition) {
        this.updateOrRegister((Java8StepDefinition)stepDefinition, this.definitions, arg_0 -> ((Glue)this.glue).addStepDefinition(arg_0));
    }

    @Override
    public void addBeforeStepHookDefinition(HookDefinition beforeStepHook) {
        this.updateOrRegister((Java8HookDefinition)beforeStepHook, this.definitions, arg_0 -> ((Glue)this.glue).addBeforeStepHook(arg_0));
    }

    @Override
    public void addAfterStepHookDefinition(HookDefinition afterStepHook) {
        this.updateOrRegister((Java8HookDefinition)afterStepHook, this.definitions, arg_0 -> ((Glue)this.glue).addAfterStepHook(arg_0));
    }

    @Override
    public void addBeforeHookDefinition(HookDefinition beforeHook) {
        this.updateOrRegister((Java8HookDefinition)beforeHook, this.definitions, arg_0 -> ((Glue)this.glue).addBeforeHook(arg_0));
    }

    @Override
    public void addAfterHookDefinition(HookDefinition afterHook) {
        this.updateOrRegister((Java8HookDefinition)afterHook, this.definitions, arg_0 -> ((Glue)this.glue).addAfterHook(arg_0));
    }

    @Override
    public void addDocStringType(DocStringTypeDefinition docStringType) {
        this.updateOrRegister((Java8DocStringTypeDefinition)docStringType, this.definitions, arg_0 -> ((Glue)this.glue).addDocStringType(arg_0));
    }

    @Override
    public void addDataTableType(DataTableTypeDefinition dataTableType) {
        this.updateOrRegister((Java8DataTableTypeDefinition)dataTableType, this.definitions, arg_0 -> ((Glue)this.glue).addDataTableType(arg_0));
    }

    @Override
    public void addParameterType(ParameterTypeDefinition parameterType) {
        this.updateOrRegister((Java8ParameterTypeDefinition)parameterType, this.definitions, arg_0 -> ((Glue)this.glue).addParameterType(arg_0));
    }

    @Override
    public void addDefaultParameterTransformer(DefaultParameterTransformerDefinition defaultParameterTransformer) {
        this.updateOrRegister((Java8DefaultParameterTransformerDefinition)defaultParameterTransformer, this.definitions, arg_0 -> ((Glue)this.glue).addDefaultParameterTransformer(arg_0));
    }

    @Override
    public void addDefaultDataTableCellTransformer(DefaultDataTableCellTransformerDefinition defaultDataTableCellTransformer) {
        this.updateOrRegister((Java8DefaultDataTableCellTransformerDefinition)defaultDataTableCellTransformer, this.definitions, arg_0 -> ((Glue)this.glue).addDefaultDataTableCellTransformer(arg_0));
    }

    @Override
    public void addDefaultDataTableEntryTransformer(DefaultDataTableEntryTransformerDefinition defaultDataTableEntryTransformer) {
        this.updateOrRegister((Java8DefaultDataTableEntryTransformerDefinition)defaultDataTableEntryTransformer, this.definitions, arg_0 -> ((Glue)this.glue).addDefaultDataTableEntryTransformer(arg_0));
    }

    private <T extends AbstractGlueDefinition> void updateOrRegister(T candidate, List<AbstractGlueDefinition> definitions, Consumer<T> register) {
        if (definitions.size() <= this.registered) {
            definitions.add(candidate);
            register.accept(candidate);
        } else {
            AbstractGlueDefinition existing = definitions.get(this.registered);
            this.requireSameGlueClass(existing, candidate);
            existing.updateClosure(candidate);
        }
        ++this.registered;
    }

    private <T extends AbstractGlueDefinition> void requireSameGlueClass(AbstractGlueDefinition existing, AbstractGlueDefinition candidate) {
        if (!existing.getClass().equals(candidate.getClass())) {
            throw new CucumberBackendException(String.format("Found an inconsistent glue registrations.\nPreviously the registration in slot %s was a '%s'. Currently '%s'.\nTo optimize performance Cucumber expects glue registration to be identical for each scenario and example.", this.registered, existing.getClass().getName(), candidate.getClass().getName()));
        }
    }

    void disposeClosures() {
        this.definitions.forEach(AbstractGlueDefinition::disposeClosure);
    }
}

