package io.cucumber.java8;

import io.cucumber.java8.StepDefinitionBody.A0;
import io.cucumber.java8.StepDefinitionBody.A1;
import io.cucumber.java8.StepDefinitionBody.A2;
import io.cucumber.java8.StepDefinitionBody.A3;
import io.cucumber.java8.StepDefinitionBody.A4;
import io.cucumber.java8.StepDefinitionBody.A5;
import io.cucumber.java8.StepDefinitionBody.A6;
import io.cucumber.java8.StepDefinitionBody.A7;
import io.cucumber.java8.StepDefinitionBody.A8;
import io.cucumber.java8.StepDefinitionBody.A9;

import io.cucumber.java8.LambdaGlueRegistry;
import io.cucumber.java8.Java8StepDefinition;
import io.cucumber.java8.LambdaGlue;

import org.apiguardian.api.API;

/**
 * Aragonese - Aragonés
 * <p>
 * To execute steps in a feature file the steps must be
 * connected to executable code. This can be done by
 * implementing this interface.
 * <p>
 * The parameters extracted from the step by the expression
 * along with the data table or doc string argument are provided as
 * arguments to the lambda expression.
 * <p>
 * The types of the parameters are determined by the cucumber or
 * regular expression.
 * <p>
 * The type of the data table or doc string argument is determined
 * by the argument name value. When none is provided cucumber will
 * attempt to transform the data table or doc string to the the
 * type of last argument.
 */
@API(status = API.Status.STABLE)
public interface An extends LambdaGlue {

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Alavez(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Alavez(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Alavez(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Alavez(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Alavez(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Alavez(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Alavez(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Alavez(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Alavez(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Alavez(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }
    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Allora(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Allora(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Allora(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Allora(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Allora(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Allora(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Allora(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Allora(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Allora(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Allora(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }
    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Antonces(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Antonces(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Antonces(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Antonces(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Antonces(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Antonces(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Antonces(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Antonces(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Antonces(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Antonces(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }
    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Cuan(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Cuan(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Cuan(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Cuan(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Cuan(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Cuan(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Cuan(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Cuan(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Cuan(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Cuan(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }
    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Dada(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Dada(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Dada(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Dada(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Dada(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Dada(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Dada(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Dada(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Dada(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Dada(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }
    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Dadas(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Dadas(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Dadas(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Dadas(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Dadas(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Dadas(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Dadas(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Dadas(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Dadas(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Dadas(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }
    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Dau(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Dau(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Dau(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Dau(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Dau(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Dau(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Dau(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Dau(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Dau(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Dau(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }
    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Daus(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Daus(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Daus(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Daus(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Daus(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Daus(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Daus(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Daus(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Daus(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Daus(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }
    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void E(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void E(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void E(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void E(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void E(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void E(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void E(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void E(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void E(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void E(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }
    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Pero(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Pero(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Pero(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Pero(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Pero(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Pero(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Pero(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Pero(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Pero(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Pero(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }
    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Y(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Y(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Y(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Y(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Y(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Y(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Y(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Y(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Y(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }
    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Y(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }
    

}
