/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java8;

import cucumber.api.Scenario;
import cucumber.api.java8.HookBody;
import cucumber.api.java8.HookNoArgsBody;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.ScenarioScoped;
import cucumber.runtime.Timeout;
import cucumber.runtime.filter.TagPredicate;
import gherkin.pickles.PickleTag;
import io.cucumber.core.event.Status;
import java.util.Arrays;
import java.util.Collection;

public class Java8HookDefinition
implements HookDefinition,
ScenarioScoped {
    private final TagPredicate tagPredicate;
    private final int order;
    private final long timeoutMillis;
    private final HookNoArgsBody hookNoArgsBody;
    private HookBody hookBody;
    private final StackTraceElement location;

    private Java8HookDefinition(String[] tagExpressions, int order, long timeoutMillis, HookBody hookBody, HookNoArgsBody hookNoArgsBody) {
        this.order = order;
        this.timeoutMillis = timeoutMillis;
        this.tagPredicate = new TagPredicate(Arrays.asList(tagExpressions));
        this.hookBody = hookBody;
        this.hookNoArgsBody = hookNoArgsBody;
        this.location = new Exception().getStackTrace()[3];
    }

    public Java8HookDefinition(String[] tagExpressions, int order, long timeoutMillis, HookBody hookBody) {
        this(tagExpressions, order, timeoutMillis, hookBody, null);
    }

    public Java8HookDefinition(String[] tagExpressions, int order, long timeoutMillis, HookNoArgsBody hookNoArgsBody) {
        this(tagExpressions, order, timeoutMillis, null, hookNoArgsBody);
    }

    public Java8HookDefinition(String tagExpression, int order, long timeoutMillis, io.cucumber.java8.HookBody hookBody) {
        this(new String[]{tagExpression}, order, timeoutMillis, (Scenario scenario) -> hookBody.accept(new ScenarioAdaptor(scenario)));
    }

    public Java8HookDefinition(String tagExpression, int order, long timeoutMillis, io.cucumber.java8.HookNoArgsBody hookNoArgsBody) {
        this(new String[]{tagExpression}, order, timeoutMillis, hookNoArgsBody::accept);
    }

    public String getLocation(boolean detail) {
        return this.location.getFileName() + ":" + this.location.getLineNumber();
    }

    public void execute(Scenario scenario) throws Throwable {
        Timeout.timeout(() -> {
            if (this.hookBody != null) {
                this.hookBody.accept(scenario);
            } else {
                this.hookNoArgsBody.accept();
            }
            return null;
        }, (long)this.timeoutMillis);
    }

    public boolean matches(Collection<PickleTag> tags) {
        return this.tagPredicate.apply(tags);
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isScenarioScoped() {
        return true;
    }

    public void disposeScenarioScope() {
        this.hookBody = null;
    }

    private static class ScenarioAdaptor
    implements io.cucumber.core.api.Scenario {
        private final Scenario scenario;

        ScenarioAdaptor(Scenario scenario) {
            this.scenario = scenario;
        }

        public Status getStatus() {
            return Status.valueOf((String)this.scenario.getStatus().name());
        }

        public boolean isFailed() {
            return this.scenario.isFailed();
        }

        public void embed(byte[] data, String mimeType) {
            this.scenario.embed(data, mimeType);
        }

        public void write(String text) {
            this.scenario.write(text);
        }

        public String getName() {
            return this.scenario.getName();
        }

        public String getId() {
            return this.scenario.getId();
        }

        public String getUri() {
            return this.scenario.getUri();
        }

        public Integer getLine() {
            return (Integer)this.scenario.getLines().get(0);
        }
    }
}

