package cucumber.api.java8;

import cucumber.api.java8.StepdefBody.A0;
import cucumber.api.java8.StepdefBody.A1;
import cucumber.api.java8.StepdefBody.A2;
import cucumber.api.java8.StepdefBody.A3;
import cucumber.api.java8.StepdefBody.A4;
import cucumber.api.java8.StepdefBody.A5;
import cucumber.api.java8.StepdefBody.A6;
import cucumber.api.java8.StepdefBody.A7;
import cucumber.api.java8.StepdefBody.A8;
import cucumber.api.java8.StepdefBody.A9;

import cucumber.runtime.java.LambdaGlueRegistry;
import cucumber.runtime.java8.Java8StepDefinition;
import cucumber.runtime.java8.LambdaGlueBase;

/**
 * To execute steps in a feature file the steps must be
 * connected to executable code. This can be done by
 * implementing this interface.
 * <p>
 * The parameters extracted from the step by the expression
 * along with the data table or doc string argument are provided as
 * arguments to the lambda expression.
 * <p>
 * The types of the parameters are determined by the cucumber or
 * regular expression.
 * <p>
 * The type of the data table or doc string argument is determined
 * by the argument name value. When none is provided cucumber will
 * attempt to transform the data table or doc string to the the
 * type of last argument.
 */
public interface Hi extends LambdaGlueBase {

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void अगर(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void अगर(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void अगर(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void अगर(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void अगर(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void अगर(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void अगर(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void अगर(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void अगर(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void अगर(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void अगर(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void अगर(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void अगर(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void अगर(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void अगर(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void अगर(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void अगर(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void अगर(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void अगर(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void अगर(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void और(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void और(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void और(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void और(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void और(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void और(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void और(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void और(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void और(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void और(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void और(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void और(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void और(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void और(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void और(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void और(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void और(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void और(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void और(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void और(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void कदा(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void कदा(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void कदा(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void कदा(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void कदा(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void कदा(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void कदा(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void कदा(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void कदा(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void कदा(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void कदा(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void कदा(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void कदा(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void कदा(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void कदा(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void कदा(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void कदा(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void कदा(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void कदा(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void कदा(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void किन्तु(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void किन्तु(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void किन्तु(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void किन्तु(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void किन्तु(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void किन्तु(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void किन्तु(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void किन्तु(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void किन्तु(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void किन्तु(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void किन्तु(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void किन्तु(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void किन्तु(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void किन्तु(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void किन्तु(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void किन्तु(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void किन्तु(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void किन्तु(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void किन्तु(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void किन्तु(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void चूंकि(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void चूंकि(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void चूंकि(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void चूंकि(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void चूंकि(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void चूंकि(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void चूंकि(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void चूंकि(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void चूंकि(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void चूंकि(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void चूंकि(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void चूंकि(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void चूंकि(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void चूंकि(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void चूंकि(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void चूंकि(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void चूंकि(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void चूंकि(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void चूंकि(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void चूंकि(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void जब(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void जब(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void जब(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void जब(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void जब(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void जब(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void जब(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void जब(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void जब(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void जब(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void जब(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void जब(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void जब(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void जब(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void जब(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void जब(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void जब(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void जब(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void जब(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void जब(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void तथा(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void तथा(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void तथा(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void तथा(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void तथा(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void तथा(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void तथा(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void तथा(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void तथा(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void तथा(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void तथा(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void तथा(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void तथा(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void तथा(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void तथा(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void तथा(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void तथा(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void तथा(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void तथा(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void तथा(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void तदा(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void तदा(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void तदा(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void तदा(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void तदा(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void तदा(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void तदा(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void तदा(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void तदा(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void तदा(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void तदा(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void तदा(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void तदा(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void तदा(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void तदा(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void तदा(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void तदा(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void तदा(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void तदा(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void तदा(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void तब(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void तब(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void तब(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void तब(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void तब(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void तब(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void तब(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void तब(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void तब(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void तब(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void तब(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void तब(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void तब(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void तब(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void तब(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void तब(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void तब(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void तब(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void तब(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void तब(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void पर(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void पर(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void पर(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void पर(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void पर(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void पर(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void पर(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void पर(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void पर(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void पर(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void पर(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void पर(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void पर(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void पर(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void पर(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void पर(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void पर(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void पर(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void पर(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void पर(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void परन्तु(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void परन्तु(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void परन्तु(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void परन्तु(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void परन्तु(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void परन्तु(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void परन्तु(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void परन्तु(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void परन्तु(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void परन्तु(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void परन्तु(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void परन्तु(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void परन्तु(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void परन्तु(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void परन्तु(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void परन्तु(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void परन्तु(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void परन्तु(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void परन्तु(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void परन्तु(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void यदि(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void यदि(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void यदि(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void यदि(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void यदि(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void यदि(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void यदि(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void यदि(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void यदि(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void यदि(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void यदि(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void यदि(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void यदि(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void यदि(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void यदि(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void यदि(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void यदि(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void यदि(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void यदि(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void यदि(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

}
