/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java;

import io.cucumber.core.backend.DocStringTypeDefinition;
import io.cucumber.core.backend.Lookup;
import io.cucumber.java.AbstractGlueDefinition;
import io.cucumber.java.DocStringType;
import io.cucumber.java.InvalidMethodSignatureException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

class JavaDocStringTypeDefinition
extends AbstractGlueDefinition
implements DocStringTypeDefinition {
    private final io.cucumber.docstring.DocStringType docStringType;

    JavaDocStringTypeDefinition(String contentType, Method method, Lookup lookup) {
        super(JavaDocStringTypeDefinition.requireValidMethod(method), lookup);
        this.docStringType = new io.cucumber.docstring.DocStringType(this.method.getGenericReturnType(), contentType.isEmpty() ? method.getName() : contentType, xva$0 -> this.invokeMethod(xva$0));
    }

    private static Method requireValidMethod(Method method) {
        Type returnType = method.getGenericReturnType();
        if (Void.class.equals((Object)returnType) || Void.TYPE.equals(returnType)) {
            throw JavaDocStringTypeDefinition.createInvalidSignatureException(method);
        }
        Type[] parameterTypes = method.getGenericParameterTypes();
        if (parameterTypes.length != 1) {
            throw JavaDocStringTypeDefinition.createInvalidSignatureException(method);
        }
        for (Type parameterType : parameterTypes) {
            if (String.class.equals((Object)parameterType)) continue;
            throw JavaDocStringTypeDefinition.createInvalidSignatureException(method);
        }
        return method;
    }

    private static InvalidMethodSignatureException createInvalidSignatureException(Method method) {
        return InvalidMethodSignatureException.builder(method).addAnnotation(DocStringType.class).addSignature("public JsonNode json(String content)").addNote("Note: JsonNode is an example of the class you want to convert content to").build();
    }

    public io.cucumber.docstring.DocStringType docStringType() {
        return this.docStringType;
    }
}

