/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java;

import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.resource.ClasspathSupport;
import io.cucumber.java.After;
import io.cucumber.java.AfterAll;
import io.cucumber.java.AfterStep;
import io.cucumber.java.Before;
import io.cucumber.java.BeforeAll;
import io.cucumber.java.BeforeStep;
import io.cucumber.java.DataTableType;
import io.cucumber.java.DefaultDataTableCellTransformer;
import io.cucumber.java.DefaultDataTableEntryTransformer;
import io.cucumber.java.DefaultParameterTransformer;
import io.cucumber.java.DocStringType;
import io.cucumber.java.InvalidMethodException;
import io.cucumber.java.Invoker;
import io.cucumber.java.ParameterType;
import io.cucumber.java.StepDefinitionAnnotation;
import io.cucumber.java.StepDefinitionAnnotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.BiConsumer;

final class MethodScanner {
    private static final Logger log = LoggerFactory.getLogger(MethodScanner.class);

    private MethodScanner() {
    }

    static void scan(Class<?> aClass, BiConsumer<Method, Annotation> consumer) {
        if (Object.class.equals(aClass)) {
            return;
        }
        if (!MethodScanner.isInstantiable(aClass)) {
            return;
        }
        for (Method method : MethodScanner.safelyGetMethods(aClass)) {
            MethodScanner.scan(consumer, aClass, method);
        }
    }

    private static Method[] safelyGetMethods(Class<?> aClass) {
        try {
            return aClass.getMethods();
        }
        catch (NoClassDefFoundError e) {
            log.warn((Throwable)e, () -> "Failed to load methods of class '" + aClass.getName() + "'.\n" + ClasspathSupport.classPathScanningExplanation());
            return new Method[0];
        }
    }

    private static boolean isInstantiable(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers()) && !Modifier.isAbstract(clazz.getModifiers()) && (Modifier.isStatic(clazz.getModifiers()) || clazz.getEnclosingClass() == null);
    }

    private static void scan(BiConsumer<Method, Annotation> consumer, Class<?> aClass, Method method) {
        if (Object.class.equals(method.getDeclaringClass())) {
            return;
        }
        if (method.isBridge()) {
            return;
        }
        MethodScanner.scan(consumer, aClass, method, method.getAnnotations());
    }

    private static void scan(BiConsumer<Method, Annotation> consumer, Class<?> aClass, Method method, Annotation[] methodAnnotations) {
        for (Annotation annotation : methodAnnotations) {
            if (MethodScanner.isHookAnnotation(annotation) || MethodScanner.isStepDefinitionAnnotation(annotation)) {
                MethodScanner.validateMethod(aClass, method);
                consumer.accept(method, annotation);
                continue;
            }
            if (!MethodScanner.isRepeatedStepDefinitionAnnotation(annotation)) continue;
            MethodScanner.scan(consumer, aClass, method, MethodScanner.repeatedAnnotations(annotation));
        }
    }

    private static void validateMethod(Class<?> glueCodeClass, Method method) {
        if (!glueCodeClass.equals(method.getDeclaringClass())) {
            throw InvalidMethodException.createInvalidMethodException(method, glueCodeClass);
        }
    }

    private static boolean isHookAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.equals(Before.class) || annotationClass.equals(BeforeAll.class) || annotationClass.equals(After.class) || annotationClass.equals(AfterAll.class) || annotationClass.equals(BeforeStep.class) || annotationClass.equals(AfterStep.class) || annotationClass.equals(ParameterType.class) || annotationClass.equals(DataTableType.class) || annotationClass.equals(DefaultParameterTransformer.class) || annotationClass.equals(DefaultDataTableEntryTransformer.class) || annotationClass.equals(DefaultDataTableCellTransformer.class) || annotationClass.equals(DocStringType.class);
    }

    private static boolean isStepDefinitionAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.getAnnotation(StepDefinitionAnnotation.class) != null;
    }

    private static boolean isRepeatedStepDefinitionAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.getAnnotation(StepDefinitionAnnotations.class) != null;
    }

    private static Annotation[] repeatedAnnotations(Annotation annotation) {
        try {
            Method expressionMethod = annotation.getClass().getMethod("value", new Class[0]);
            return (Annotation[])Invoker.invoke(annotation, expressionMethod);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }
}

