/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import io.cucumber.java.Transpose;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

class ParameterInfo {
    private final Type type;
    private final boolean transposed;

    static List<ParameterInfo> fromMethod(Method method) {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            boolean transposed = false;
            for (Annotation annotation : annotations[i]) {
                if (!(annotation instanceof cucumber.api.Transpose) && !(annotation instanceof Transpose)) continue;
                transposed = ((cucumber.api.Transpose)annotation).value();
            }
            result.add(new ParameterInfo(genericParameterTypes[i], transposed));
        }
        return result;
    }

    private ParameterInfo(Type type, boolean transposed) {
        this.type = type;
        this.transposed = transposed;
    }

    Type getType() {
        return this.type;
    }

    boolean isTransposed() {
        return this.transposed;
    }

    public String toString() {
        return this.type.toString();
    }
}

