/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.groovy;

import cucumber.runtime.StepDefinition;
import cucumber.runtime.Timeout;
import cucumber.runtime.groovy.GroovyBackend;
import cucumber.runtime.groovy.ParameterInfo;
import gherkin.pickles.PickleStep;
import groovy.lang.Closure;
import io.cucumber.stepexpression.Argument;
import io.cucumber.stepexpression.ExpressionArgumentMatcher;
import io.cucumber.stepexpression.StepExpression;
import io.cucumber.stepexpression.StepExpressionFactory;
import io.cucumber.stepexpression.TypeRegistry;
import java.lang.reflect.Type;
import java.util.List;
import org.codehaus.groovy.runtime.StackTraceUtils;

public class GroovyStepDefinition
implements StepDefinition {
    private final String pattern;
    private final long timeoutMillis;
    private final Closure body;
    private final StackTraceElement location;
    private final GroovyBackend backend;
    private final StepExpression expression;
    private final List<ParameterInfo> parameterInfos;

    public GroovyStepDefinition(String pattern, long timeoutMillis, Closure body, StackTraceElement location, GroovyBackend backend, TypeRegistry typeRegistry) {
        this.pattern = pattern;
        this.timeoutMillis = timeoutMillis;
        this.backend = backend;
        this.body = body;
        this.location = location;
        this.parameterInfos = this.getParameterInfos();
        this.expression = this.createExpression(pattern, typeRegistry);
    }

    private StepExpression createExpression(String expression, TypeRegistry typeRegistry) {
        if (this.parameterInfos.isEmpty()) {
            return new StepExpressionFactory(typeRegistry).createExpression(expression);
        }
        ParameterInfo parameterInfo = this.parameterInfos.get(this.parameterInfos.size() - 1);
        return new StepExpressionFactory(typeRegistry).createExpression(expression, parameterInfo.getType(), parameterInfo.isTransposed());
    }

    public List<Argument> matchedArguments(PickleStep step) {
        ExpressionArgumentMatcher argumentMatcher = new ExpressionArgumentMatcher(this.expression);
        Type[] types = new Type[this.parameterInfos.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.parameterInfos.get(i).getType();
        }
        return argumentMatcher.argumentsFrom(step, types);
    }

    public String getLocation(boolean detail) {
        return this.location.getFileName() + ":" + this.location.getLineNumber();
    }

    public Integer getParameterCount() {
        return this.parameterInfos.size();
    }

    private List<ParameterInfo> getParameterInfos() {
        Type[] parameterTypes = this.body.getParameterTypes();
        return ParameterInfo.fromTypes(parameterTypes);
    }

    public void execute(Object[] args) throws Throwable {
        try {
            Timeout.timeout(() -> {
                this.backend.invoke(this.body, args);
                return null;
            }, (long)this.timeoutMillis);
        }
        catch (Throwable e) {
            throw StackTraceUtils.deepSanitize((Throwable)e);
        }
    }

    public boolean isDefinedAt(StackTraceElement stackTraceElement) {
        return this.location.getFileName().equals(stackTraceElement.getFileName());
    }

    public String getPattern() {
        return this.expression.getSource();
    }

    public boolean isScenarioScoped() {
        return false;
    }
}

