/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.groovy;

import cucumber.api.Scenario;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.Timeout;
import cucumber.runtime.filter.TagPredicate;
import cucumber.runtime.groovy.GroovyBackend;
import gherkin.pickles.PickleTag;
import groovy.lang.Closure;
import java.util.Collection;

public class GroovyHookDefinition
implements HookDefinition {
    private final TagPredicate tagPredicate;
    private final long timeoutMillis;
    private final int order;
    private final Closure body;
    private final GroovyBackend backend;
    private final StackTraceElement location;

    public GroovyHookDefinition(TagPredicate tagPredicate, long timeoutMillis, int order, Closure body, StackTraceElement location, GroovyBackend backend) {
        this.tagPredicate = tagPredicate;
        this.timeoutMillis = timeoutMillis;
        this.order = order;
        this.body = body;
        this.location = location;
        this.backend = backend;
    }

    public String getLocation(boolean detail) {
        return this.location.getFileName() + ":" + this.location.getLineNumber();
    }

    public void execute(final Scenario scenario) throws Throwable {
        Timeout.timeout((Timeout.Callback)new Timeout.Callback<Object>(){

            public Object call() throws Throwable {
                GroovyHookDefinition.this.backend.invoke(GroovyHookDefinition.this.body, new Object[]{scenario});
                return null;
            }
        }, (long)this.timeoutMillis);
    }

    public boolean matches(Collection<PickleTag> tags) {
        return this.tagPredicate.apply(tags);
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isScenarioScoped() {
        return false;
    }
}

