/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.groovy;

import cucumber.runtime.Argument;
import cucumber.runtime.JdkPatternArgumentMatcher;
import cucumber.runtime.ParameterInfo;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.Timeout;
import cucumber.runtime.groovy.GroovyBackend;
import gherkin.pickles.PickleStep;
import groovy.lang.Closure;
import java.lang.reflect.Type;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.StackTraceUtils;

public class GroovyStepDefinition
implements StepDefinition {
    private final Pattern pattern;
    private final long timeoutMillis;
    private final Closure body;
    private final StackTraceElement location;
    private final GroovyBackend backend;
    private final JdkPatternArgumentMatcher argumentMatcher;
    private final List<ParameterInfo> parameterInfos;

    public GroovyStepDefinition(Pattern pattern, long timeoutMillis, Closure body, StackTraceElement location, GroovyBackend backend) {
        this.pattern = pattern;
        this.timeoutMillis = timeoutMillis;
        this.backend = backend;
        this.body = body;
        this.location = location;
        this.argumentMatcher = new JdkPatternArgumentMatcher(pattern);
        this.parameterInfos = this.getParameterInfos();
    }

    public List<Argument> matchedArguments(PickleStep step) {
        return this.argumentMatcher.argumentsFrom(step.getText());
    }

    public String getLocation(boolean detail) {
        return this.location.getFileName() + ":" + this.location.getLineNumber();
    }

    public Integer getParameterCount() {
        return this.parameterInfos.size();
    }

    public ParameterInfo getParameterType(int n, Type argumentType) {
        return this.parameterInfos.get(n);
    }

    private List<ParameterInfo> getParameterInfos() {
        Type[] parameterTypes = this.body.getParameterTypes();
        return ParameterInfo.fromTypes((Type[])parameterTypes);
    }

    public void execute(String language, final Object[] args) throws Throwable {
        try {
            Timeout.timeout((Timeout.Callback)new Timeout.Callback<Object>(){

                public Object call() throws Throwable {
                    GroovyStepDefinition.this.backend.invoke(GroovyStepDefinition.this.body, args);
                    return null;
                }
            }, (long)this.timeoutMillis);
        }
        catch (Throwable e) {
            throw StackTraceUtils.deepSanitize((Throwable)e);
        }
    }

    public boolean isDefinedAt(StackTraceElement stackTraceElement) {
        return this.location.getFileName().equals(stackTraceElement.getFileName());
    }

    public String getPattern() {
        return this.pattern.pattern();
    }

    public boolean isScenarioScoped() {
        return false;
    }
}

