/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.groovy;

import cucumber.runtime.Backend;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.TagPredicate;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.groovy.GroovyHookDefinition;
import cucumber.runtime.groovy.GroovySnippet;
import cucumber.runtime.groovy.GroovyStepDefinition;
import cucumber.runtime.groovy.GroovyWorld;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.snippets.FunctionNameGenerator;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.pickles.PickleStep;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerInvocationException;

public class GroovyBackend
implements Backend {
    public static ThreadLocal<GroovyBackend> instanceThreadLocal = new ThreadLocal();
    private final Set<Class> scripts = new HashSet<Class>();
    private final SnippetGenerator snippetGenerator = new SnippetGenerator((Snippet)new GroovySnippet());
    private final ResourceLoader resourceLoader;
    private final GroovyShell shell;
    private final ClassFinder classFinder;
    private Collection<Closure> worldClosures = new LinkedList<Closure>();
    private GroovyWorld world;
    private Glue glue;

    public static GroovyBackend getInstance() {
        return instanceThreadLocal.get();
    }

    private static GroovyShell createShell() {
        CompilerConfiguration compilerConfig = new CompilerConfiguration();
        return new GroovyShell(Thread.currentThread().getContextClassLoader(), new Binding(), compilerConfig);
    }

    public GroovyBackend(ResourceLoader resourceLoader) {
        this(GroovyBackend.createShell(), resourceLoader);
    }

    public GroovyBackend(GroovyShell shell, ResourceLoader resourceLoader) {
        this.shell = shell;
        this.resourceLoader = resourceLoader;
        instanceThreadLocal.set(this);
        this.classFinder = new ResourceLoaderClassFinder(resourceLoader, (ClassLoader)shell.getClassLoader());
    }

    public void loadGlue(Glue glue, List<String> gluePaths) {
        this.glue = glue;
        Binding context = this.shell.getContext();
        for (String gluePath : gluePaths) {
            Script script;
            for (Resource resource : this.resourceLoader.resources(gluePath, ".groovy")) {
                script = this.parse(resource);
                this.runIfScript(context, script);
            }
            for (Class glueClass : this.classFinder.getDescendants(Script.class, MultiLoader.packageName((String)gluePath))) {
                try {
                    script = (Script)glueClass.getConstructor(Binding.class).newInstance(context);
                    this.runIfScript(context, script);
                }
                catch (Exception e) {
                    throw new CucumberException((Throwable)e);
                }
            }
        }
    }

    private void runIfScript(Binding context, Script script) {
        Class scriptClass = script.getMetaClass().getTheClass();
        if (this.isScript(script) && !this.scripts.contains(scriptClass)) {
            script.setBinding(context);
            script.run();
            this.scripts.add(scriptClass);
        }
    }

    public void setUnreportedStepExecutor(UnreportedStepExecutor executor) {
    }

    public void buildWorld() {
        this.world = new GroovyWorld();
        for (Closure closure : this.worldClosures) {
            this.world.registerWorld(closure.call());
        }
    }

    private Script parse(Resource resource) {
        try {
            return this.shell.parse((Reader)new InputStreamReader(resource.getInputStream(), "UTF-8"), resource.getAbsolutePath());
        }
        catch (IOException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    private boolean isScript(Script script) {
        return DefaultGroovyMethods.asBoolean((Collection)script.getMetaClass().respondsTo((Object)script, "main"));
    }

    public void disposeWorld() {
        this.world = null;
    }

    public String getSnippet(PickleStep step, String keyword, FunctionNameGenerator functionNameGenerator) {
        return this.snippetGenerator.getSnippet(step, keyword, null);
    }

    public void addStepDefinition(Pattern regexp, long timeoutMillis, Closure body) {
        this.glue.addStepDefinition((StepDefinition)new GroovyStepDefinition(regexp, timeoutMillis, body, GroovyBackend.currentLocation(), this));
    }

    public void registerWorld(Closure closure) {
        this.worldClosures.add(closure);
    }

    public void addBeforeHook(TagPredicate tagPredicate, long timeoutMillis, int order, Closure body) {
        this.glue.addBeforeHook((HookDefinition)new GroovyHookDefinition(tagPredicate, timeoutMillis, order, body, GroovyBackend.currentLocation(), this));
    }

    public void addAfterHook(TagPredicate tagPredicate, long timeoutMillis, int order, Closure body) {
        this.glue.addAfterHook((HookDefinition)new GroovyHookDefinition(tagPredicate, timeoutMillis, order, body, GroovyBackend.currentLocation(), this));
    }

    public void invoke(Closure body, Object[] args) throws Throwable {
        body.setResolveStrategy(1);
        body.setDelegate((Object)this.world);
        try {
            body.call(args);
        }
        catch (InvokerInvocationException e) {
            throw e.getCause();
        }
    }

    GroovyWorld getGroovyWorld() {
        return this.world;
    }

    private static StackTraceElement currentLocation() {
        StackTraceElement[] stackTraceElements;
        Throwable t = new Throwable();
        for (StackTraceElement stackTraceElement : stackTraceElements = t.getStackTrace()) {
            if (!GroovyBackend.isGroovyFile(stackTraceElement.getFileName())) continue;
            return stackTraceElement;
        }
        throw new RuntimeException("Couldn't find location for step definition");
    }

    private static boolean isGroovyFile(String fileName) {
        return fileName != null && fileName.endsWith(".groovy");
    }
}

