/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.AnsiEscapes;
import io.cucumber.core.plugin.NiceAppendable;
import io.cucumber.core.plugin.UTF8OutputStreamWriter;
import io.cucumber.plugin.ColorAware;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestStepFinished;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public final class ProgressFormatter
implements ConcurrentEventListener,
ColorAware {
    private static final Map<Status, Character> CHARS = new HashMap<Status, Character>(){
        {
            this.put(Status.PASSED, Character.valueOf('.'));
            this.put(Status.UNDEFINED, Character.valueOf('U'));
            this.put(Status.PENDING, Character.valueOf('P'));
            this.put(Status.SKIPPED, Character.valueOf('-'));
            this.put(Status.FAILED, Character.valueOf('F'));
            this.put(Status.AMBIGUOUS, Character.valueOf('A'));
        }
    };
    private static final Map<Status, AnsiEscapes> ANSI_ESCAPES = new HashMap<Status, AnsiEscapes>(){
        {
            this.put(Status.PASSED, AnsiEscapes.GREEN);
            this.put(Status.UNDEFINED, AnsiEscapes.YELLOW);
            this.put(Status.PENDING, AnsiEscapes.YELLOW);
            this.put(Status.SKIPPED, AnsiEscapes.CYAN);
            this.put(Status.FAILED, AnsiEscapes.RED);
            this.put(Status.AMBIGUOUS, AnsiEscapes.RED);
        }
    };
    private final NiceAppendable out;
    private boolean monochrome = false;

    public ProgressFormatter(OutputStream out) {
        this.out = new NiceAppendable(new UTF8OutputStreamWriter(out), true);
    }

    public void setMonochrome(boolean monochrome) {
        this.monochrome = monochrome;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestStepFinished.class, this::handleTestStepFinished);
        publisher.registerHandlerFor(TestRunFinished.class, this::handleTestRunFinished);
    }

    private void handleTestStepFinished(TestStepFinished event) {
        boolean isTestStep = event.getTestStep() instanceof PickleStepTestStep;
        boolean isFailedHookOrTestStep = event.getResult().getStatus().is(Status.FAILED);
        if (!isTestStep && !isFailedHookOrTestStep) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        if (!this.monochrome) {
            ANSI_ESCAPES.get(event.getResult().getStatus()).appendTo(buffer);
        }
        buffer.append(CHARS.get(event.getResult().getStatus()));
        if (!this.monochrome) {
            AnsiEscapes.RESET.appendTo(buffer);
        }
        this.out.append(buffer);
    }

    private void handleTestRunFinished(TestRunFinished testRunFinished) {
        this.out.println();
        this.out.close();
    }
}

