/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.messages.types.Envelope;
import io.cucumber.plugin.ColorAware;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.prettyformatter.MessagesToProgressWriter;
import io.cucumber.prettyformatter.Theme;
import java.io.IOException;
import java.io.OutputStream;

public final class ProgressFormatter
implements ConcurrentEventListener,
ColorAware {
    private final OutputStream out;
    private MessagesToProgressWriter writer;

    public ProgressFormatter(OutputStream out) {
        this.out = out;
        this.writer = ProgressFormatter.createBuilder().build(out);
    }

    private static MessagesToProgressWriter.Builder createBuilder() {
        return MessagesToProgressWriter.builder().theme(Theme.cucumber());
    }

    public void setMonochrome(boolean monochrome) {
        if (monochrome) {
            this.writer = ProgressFormatter.createBuilder().theme(Theme.plain()).build(this.out);
        }
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(Envelope.class, this::write);
    }

    private void write(Envelope event) {
        try {
            this.writer.write(event);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (event.getTestRunFinished().isPresent()) {
            this.writer.close();
        }
    }
}

