/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.feature.FeatureWithLines;
import io.cucumber.core.feature.GluePath;
import io.cucumber.core.options.ObjectFactoryParser;
import io.cucumber.core.options.OptionsFileParser;
import io.cucumber.core.options.PickleOrderParser;
import io.cucumber.core.options.PublishTokenParser;
import io.cucumber.core.options.RuntimeOptionsBuilder;
import io.cucumber.core.options.SnippetTypeParser;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CucumberPropertiesParser {
    public RuntimeOptionsBuilder parse(Map<String, String> properties) {
        RuntimeOptionsBuilder builder = new RuntimeOptionsBuilder();
        this.parse(properties, "cucumber.ansi-colors.disabled", Boolean::parseBoolean, builder::setMonochrome);
        this.parse(properties, "cucumber.execution.dry-run", Boolean::parseBoolean, builder::setDryRun);
        this.parse(properties, "cucumber.execution.limit", Integer::parseInt, builder::setCount);
        this.parse(properties, "cucumber.execution.order", PickleOrderParser::parse, builder::setPickleOrder);
        this.parse(properties, "cucumber.execution.strict", Boolean::parseBoolean, CucumberPropertiesParser::errorOnNonStrict);
        this.parseAll(properties, "cucumber.features", CucumberPropertiesParser.splitAndThenFlatMap(CucumberPropertiesParser::parseFeatureFile), builder::addFeature);
        this.parseAll(properties, "cucumber.features", CucumberPropertiesParser.splitAndThenFlatMap(CucumberPropertiesParser::parseRerunFile), builder::addRerun);
        this.parse(properties, "cucumber.filter.name", Pattern::compile, builder::addNameFilter);
        this.parse(properties, "cucumber.filter.tags", TagExpressionParser::parse, builder::addTagFilter);
        this.parseAll(properties, "cucumber.glue", CucumberPropertiesParser.splitAndMap(GluePath::parse), builder::addGlue);
        this.parse(properties, "cucumber.object-factory", ObjectFactoryParser::parseObjectFactory, builder::setObjectFactoryClass);
        this.parseAll(properties, "cucumber.plugin", CucumberPropertiesParser.splitAndMap(Function.identity()), builder::addPluginName);
        this.parse(properties, "cucumber.publish.token", PublishTokenParser::parse, builder::setPublishToken);
        this.parse(properties, "cucumber.publish.enabled", Boolean::parseBoolean, builder::setPublish);
        this.parse(properties, "cucumber.publish.quiet", Boolean::parseBoolean, builder::setPublishQuiet);
        this.parse(properties, "cucumber.snippet-type", SnippetTypeParser::parseSnippetType, builder::setSnippetType);
        this.parse(properties, "cucumber.execution.wip", Boolean::parseBoolean, builder::setWip);
        return builder;
    }

    private <T> void parse(Map<String, String> properties, String propertyName, Function<String, T> parser, Consumer<T> setter) {
        this.parseAll(properties, propertyName, parser.andThen(Collections::singletonList), setter);
    }

    private static void errorOnNonStrict(Boolean strict) {
        if (!strict.booleanValue()) {
            throw new CucumberException("cucumber.execution.strict=false is no longer effective. Please use =true (the default) or remove this property");
        }
    }

    private <T> void parseAll(Map<String, String> properties, String propertyName, Function<String, Collection<T>> parser, Consumer<T> setter) {
        String property = properties.get(propertyName);
        if (property == null || property.isEmpty()) {
            return;
        }
        try {
            Collection<T> parsed = parser.apply(property);
            parsed.forEach(setter);
        }
        catch (Exception e) {
            throw new CucumberException("Failed to parse '" + propertyName + "' with value '" + property + "'", e);
        }
    }

    private static <T> Function<String, Collection<T>> splitAndThenFlatMap(Function<String, Stream<T>> parse) {
        return combined -> Arrays.stream(combined.split(",")).map(String::trim).filter(part -> !part.isEmpty()).flatMap(parse).collect(Collectors.toList());
    }

    private static Stream<FeatureWithLines> parseFeatureFile(String property) {
        if (property.startsWith("@")) {
            return Stream.empty();
        }
        return Stream.of(FeatureWithLines.parse(property));
    }

    private static <T> Function<String, Collection<T>> splitAndMap(Function<String, T> parse) {
        return combined -> Arrays.stream(combined.split(",")).map(String::trim).filter(part -> !part.isEmpty()).map(parse).collect(Collectors.toList());
    }

    private static Stream<Collection<FeatureWithLines>> parseRerunFile(String property) {
        if (property.startsWith("@")) {
            Path rerunFile = Paths.get(property.substring(1), new String[0]);
            return Stream.of(OptionsFileParser.parseFeatureWithLinesFile(rerunFile));
        }
        return Stream.empty();
    }
}

