/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.options.CurlOption;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class UrlOutputStream
extends OutputStream {
    private final CurlOption option;
    private final Path temp;
    private final OutputStream tempOutputStream;

    UrlOutputStream(CurlOption option) throws IOException {
        this.option = option;
        this.temp = Files.createTempFile("cucumber", null, new FileAttribute[0]);
        this.tempOutputStream = Files.newOutputStream(this.temp, new OpenOption[0]);
    }

    @Override
    public void write(int b) throws IOException {
        this.tempOutputStream.write(b);
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.tempOutputStream.write(buffer);
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        this.tempOutputStream.write(buffer, offset, count);
    }

    @Override
    public void flush() throws IOException {
        this.tempOutputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.tempOutputStream.close();
        URL url = this.option.getUri().toURL();
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        for (Map.Entry<String, String> header : this.option.getHeaders()) {
            urlConnection.setRequestProperty(header.getKey(), header.getValue());
        }
        urlConnection.setInstanceFollowRedirects(true);
        urlConnection.setRequestMethod(this.option.getMethod().name());
        urlConnection.setDoOutput(true);
        Map<String, List<String>> requestHeaders = urlConnection.getRequestProperties();
        try (OutputStream outputStream = urlConnection.getOutputStream();){
            Files.copy(this.temp, outputStream);
            UrlOutputStream.handleResponse(urlConnection, requestHeaders);
        }
    }

    private static void handleResponse(HttpURLConnection urlConnection, Map<String, List<String>> requestHeaders) throws IOException {
        Map<String, List<String>> responseHeaders = urlConnection.getHeaderFields();
        int responseCode = urlConnection.getResponseCode();
        boolean success = 200 <= responseCode && responseCode < 300;
        InputStream inputStream = urlConnection.getErrorStream() != null ? urlConnection.getErrorStream() : urlConnection.getInputStream();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String responseBody = br.lines().collect(Collectors.joining(System.lineSeparator()));
            if (!success) {
                String method = urlConnection.getRequestMethod();
                URL url = urlConnection.getURL();
                throw UrlOutputStream.createCurlLikeException(method, url, requestHeaders, responseHeaders, responseBody);
            }
        }
    }

    static IOException createCurlLikeException(String method, URL url, Map<String, List<String>> requestHeaders, Map<String, List<String>> responseHeaders, String responseBody) {
        return new IOException(String.format("%s:\n> %s %s%s%s%s", "HTTP request failed", method, url, UrlOutputStream.headersToString("> ", requestHeaders), UrlOutputStream.headersToString("< ", responseHeaders), responseBody));
    }

    private static String headersToString(String prefix, Map<String, List<String>> headers) {
        return headers.entrySet().stream().flatMap(header -> ((List)header.getValue()).stream().map(value -> {
            if (header.getKey() == null) {
                return prefix + value;
            }
            if (header.getValue() == null) {
                return prefix + (String)header.getKey();
            }
            return prefix + (String)header.getKey() + ": " + value;
        })).collect(Collectors.joining("\n", "", "\n"));
    }
}

